#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 13:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `live_consult` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `time`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `global_shift_id`, `shift_id`, `is_queue`, `live_consult`, `created_at`) VALUES (2, 821, 140, 123, '2023-05-18 18:00:00', NULL, '1', '', 12, '', 'Headaches, fever, vommitting', 'approved', 'Offline', '', '', 2, 17, 0, 'no', '2023-05-18 16:18:21');


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, 'RM-001', 1, 1, 'yes', '2023-02-03 06:51:37');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, 'RM-002', 1, 1, 'yes', '2023-02-03 06:52:17');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, 'RM-003', 1, 1, 'yes', '2023-02-03 06:52:37');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, 'VIP-RM-01', 2, 2, 'yes', '2023-02-03 06:53:17');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (5, 'Emergency Bed', 1, 1, 'no', '2023-05-24 15:38:59');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` varchar(200) NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'Private Ward', '#f4f4f4', '', 1, 0, '2023-02-03 06:49:14');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'VIP Ward', '#f4f4f4', '', 1, 0, '2023-02-03 06:49:31');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'Standard', '2023-02-03 06:50:01');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'VIP', '2023-02-03 06:50:38');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` varchar(200) NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, 'KosisoChukwu Ava Onyedika Onuoha', 'uploads/patient_images/no_image.png', 'Female', '2023-02-26 09:00:00', '2.4', 314, 6, '0915220331', 'uploads/patient_images/no_image.png', 'Kingsley Onyedika Onuoha', 'uploads/patient_images/no_image.png', 'Normal', '', 'FHA Estate Lugbe', 'yes', '2023-04-20 15:25:48');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (2, 'Jahemerielam Nkechinyerem Shulammite Brown', 'uploads/patient_images/no_image.png', 'Female', '2023-04-20 11:30:00', '2.9', 1350, 50, '', 'uploads/patient_images/no_image.png', 'Tatteh Brown', 'uploads/patient_images/no_image.png', 'Delivered Via CS ', '', '', 'yes', '2023-04-20 15:25:25');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (3, 'Davis David', 'uploads/patient_images/no_image.png', 'Male', '2023-04-25 11:03:00', '3.5', 312, 113, '', 'uploads/patient_images/no_image.png', 'Kingsley David', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2023-05-23 10:04:42');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (4, 'Uriel Oreoluwa', 'uploads/patient_images/no_image.png', 'Male', '2023-05-09 11:07:00', '3.0', 315, 105, '', 'uploads/patient_images/no_image.png', 'Mr Ogundipe', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2023-05-23 10:08:09');


#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (1, 'O+', 1, '2023-02-10 12:14:47');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (2, 'A+', 1, '2023-02-10 12:15:02');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (3, 'B+', 1, '2023-02-10 12:15:14');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (4, 'AB+', 1, '2023-02-10 12:15:25');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (5, 'O-', 1, '2023-02-10 12:16:13');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (6, 'A-', 1, '2023-02-10 12:16:24');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (7, 'AB-', 1, '2023-02-10 12:16:37');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (8, 'B-', 1, '2023-02-10 12:16:54');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `remark` mediumtext DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 05:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 05:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 1, '2023-04-19 13:55:12');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `case_references` (`id`, `created_at`) VALUES (1, '2023-02-10 11:19:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (2, '2023-02-10 13:42:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (3, '2023-02-10 13:47:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (4, '2023-03-01 11:30:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (5, '2023-03-06 13:27:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (6, '2023-03-09 10:09:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (7, '2023-03-09 10:23:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (8, '2023-03-13 08:10:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (9, '2023-03-20 11:17:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (10, '2023-03-20 11:20:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (11, '2023-03-21 10:37:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (12, '2023-03-22 08:27:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (13, '2023-03-22 09:16:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (14, '2023-03-22 10:04:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (15, '2023-03-22 11:43:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (16, '2023-03-22 12:06:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (17, '2023-03-23 09:10:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (18, '2023-03-23 10:41:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (19, '2023-03-23 10:51:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (20, '2023-03-24 08:31:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (21, '2023-03-24 08:33:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (22, '2023-03-24 12:59:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (23, '2023-03-27 08:47:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (24, '2023-03-27 09:14:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (25, '2023-03-27 10:31:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (26, '2023-03-29 07:38:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (27, '2023-03-29 13:56:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (28, '2023-03-29 14:08:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (29, '2023-03-30 14:23:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (30, '2023-03-30 14:28:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (31, '2023-03-30 14:35:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (32, '2023-03-31 09:08:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (33, '2023-03-31 10:45:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (34, '2023-03-31 15:35:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (35, '2023-04-11 08:55:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (36, '2023-04-12 10:29:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (37, '2023-04-12 10:36:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (38, '2023-04-12 10:40:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (39, '2023-04-12 10:42:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (40, '2023-04-14 07:11:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (41, '2023-04-14 07:13:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (42, '2023-04-14 07:15:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (43, '2023-04-14 07:16:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (44, '2023-04-17 06:58:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (45, '2023-04-17 07:00:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (46, '2023-04-17 07:01:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (47, '2023-04-17 14:53:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (48, '2023-04-17 14:57:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (49, '2023-04-18 09:35:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (50, '2023-04-18 09:58:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (51, '2023-04-18 10:26:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (52, '2023-04-18 12:24:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (53, '2023-04-18 12:27:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (54, '2023-04-19 12:09:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (55, '2023-04-19 12:53:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (56, '2023-04-19 14:16:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (57, '2023-04-19 15:22:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (58, '2023-04-19 15:24:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (59, '2023-04-20 10:15:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (60, '2023-04-20 10:28:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (61, '2023-04-20 12:36:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (62, '2023-04-20 13:04:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (63, '2023-04-20 14:44:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (64, '2023-04-25 13:37:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (65, '2023-04-25 13:39:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (66, '2023-04-25 13:45:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (67, '2023-04-26 11:21:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (68, '2023-04-26 12:01:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (69, '2023-04-28 09:16:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (70, '2023-04-28 09:31:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (71, '2023-04-28 10:54:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (72, '2023-04-28 15:22:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (73, '2023-05-01 10:58:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (74, '2023-05-01 11:00:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (75, '2023-05-01 14:51:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (76, '2023-05-01 14:52:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (77, '2023-05-01 15:23:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (78, '2023-05-02 09:19:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (79, '2023-05-02 09:23:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (80, '2023-05-02 09:45:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (81, '2023-05-02 10:31:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (82, '2023-05-02 11:21:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (83, '2023-05-02 13:23:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (84, '2023-05-03 08:05:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (85, '2023-05-03 08:23:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (86, '2023-05-03 13:00:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (87, '2023-05-04 06:06:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (88, '2023-05-04 09:06:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (89, '2023-05-04 09:44:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (90, '2023-05-04 10:49:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (91, '2023-05-04 15:54:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (92, '2023-05-05 09:17:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (93, '2023-05-05 10:03:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (94, '2023-05-05 11:45:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (95, '2023-05-05 12:05:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (96, '2023-05-05 12:10:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (97, '2023-05-05 12:23:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (98, '2023-05-05 12:27:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (99, '2023-05-05 12:35:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (100, '2023-05-08 14:02:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (101, '2023-05-08 14:08:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (102, '2023-05-08 14:13:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (103, '2023-05-08 14:17:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (104, '2023-05-09 08:00:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (105, '2023-05-09 08:07:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (106, '2023-05-09 08:20:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (107, '2023-05-09 08:27:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (108, '2023-05-09 08:40:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (109, '2023-05-09 11:38:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (110, '2023-05-09 11:42:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (111, '2023-05-09 11:43:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (112, '2023-05-10 07:39:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (113, '2023-05-10 14:25:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (114, '2023-05-11 07:11:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (115, '2023-05-11 09:50:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (116, '2023-05-11 09:57:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (117, '2023-05-11 10:02:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (118, '2023-05-11 10:56:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (119, '2023-05-11 10:58:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (120, '2023-05-12 09:42:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (121, '2023-05-12 09:48:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (122, '2023-05-12 10:54:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (123, '2023-05-12 11:46:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (124, '2023-05-12 14:25:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (125, '2023-05-12 14:37:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (126, '2023-05-12 14:51:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (127, '2023-05-15 08:39:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (128, '2023-05-16 07:51:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (129, '2023-05-16 11:18:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (130, '2023-05-16 11:21:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (131, '2023-05-16 11:32:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (132, '2023-05-16 15:02:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (133, '2023-05-17 12:01:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (134, '2023-05-17 13:01:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (135, '2023-05-18 08:38:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (136, '2023-05-18 11:17:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (137, '2023-05-18 14:24:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (138, '2023-05-18 16:09:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (139, '2023-05-18 16:10:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (140, '2023-05-18 16:18:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (141, '2023-05-18 16:18:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (142, '2023-05-22 08:54:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (143, '2023-05-22 08:58:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (144, '2023-05-22 09:02:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (145, '2023-05-22 09:08:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (146, '2023-05-22 09:12:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (147, '2023-05-22 11:07:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (148, '2023-05-22 11:12:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (149, '2023-05-23 09:57:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (150, '2023-05-23 10:14:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (151, '2023-05-23 10:42:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (152, '2023-05-24 11:03:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (153, '2023-05-24 11:06:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (154, '2023-05-24 11:26:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (155, '2023-05-24 12:17:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (156, '2023-05-25 14:26:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (157, '2023-05-26 08:38:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (158, '2023-05-26 08:52:36');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (159, '2023-05-26 08:55:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (160, '2023-05-26 08:59:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (161, '2023-05-26 14:15:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (162, '2023-05-26 14:50:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (163, '2023-05-27 13:48:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (164, '2023-05-27 14:57:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (165, '2023-05-30 09:23:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (166, '2023-05-30 09:39:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (167, '2023-05-30 10:21:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (168, '2023-05-30 10:37:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (169, '2023-05-30 10:40:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (170, '2023-05-30 11:19:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (171, '2023-05-30 17:57:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (172, '2023-05-30 17:59:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (173, '2023-06-01 08:37:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (174, '2023-06-01 10:34:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (175, '2023-06-01 11:01:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (176, '2023-06-02 11:29:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (177, '2023-06-02 11:43:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (178, '2023-06-02 11:51:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (179, '2023-06-02 12:56:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (180, '2023-06-02 14:03:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (181, '2023-06-02 14:11:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (182, '2023-06-09 10:15:52');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (1, 5, 'Chest X-ray ', 'AP/Lat', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 5, 'Lumbosacral Spine ', 'AP/Lat', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 2, 'General Consulation', 'Fresh', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 2, 'General Consulation (Review)', 'Review', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 2, 'Specialist Consulation', 'O&G', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 2, 'Consultation', 'Physician', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (7, 3, 'Admission Deposit', 'Minor', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 3, 'Admission Deposit MM', 'Major Minor', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 3, 'Admission Deposit MJMJ', 'Major Major ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 13, 'Nursing Services', 'Nursing Services', NULL, '', '2023-03-01 11:41:11');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 4, 'Heamatology', 'Heamatology ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 4, 'Serology', 'Serology fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'Endocrinology', 'Endocrinology Fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (16, 4, 'Immunology', 'Immunology Fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (17, 4, 'Histology and Cytology', 'Histology and Cytology fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (18, 4, 'Clinical Chemistry', 'Clinical Chemistry', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (19, 4, 'Molecular Biology', 'Molecular Biology', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (20, 4, 'Microbiology', 'Microbiology', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (21, 4, 'Parasitology', 'Parasitology', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (22, 4, 'Therapeutic Drug Monitoring (TDM)', 'Therapeutic Drug Monitoring (TDM)', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (23, 2, 'Ante Natal Care Registration', '8 OPD Routine Consultations Investigations/ Excluding Admission and intercurrent Illness ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (24, 1, 'General Consultation', 'Appointment Consultation', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (25, 3, 'Admission Deposit Major', 'Major requiring up to 1 week admission plus or minor any procedure', NULL, '', '2023-05-20 13:33:22');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (26, 8, 'Ceseraean Section', 'O & G Surgical', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (27, 8, 'Myomectomy', 'O & G Surgical', NULL, '', '2023-05-20 13:41:26');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (28, 8, 'Operating Theater Or Room (OT or OR)', 'Use of Operating Theater (OT or OR)', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (29, 8, 'Anesthesia', 'Anesthesia', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (30, 8, 'Appendectomy', 'General Surgery', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (31, 8, 'herniotomy/Hernioplasty', 'General Surgery', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (32, 8, 'Lumpectomy', 'General Surgery', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (33, 8, 'Circumcision ', 'General ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (34, 8, 'Manual Vaccum Aspiration/ Dilatation and Curretage', 'O & G', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (35, 8, 'Total Hip Replacement (Arthroplasty)', 'Orthopedics', NULL, '', '2023-05-20 14:01:10');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (36, 8, 'Total Knee Replacement (Arthroplasty)', 'Orthopedics', NULL, '', '2023-05-20 14:00:47');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (37, 8, 'Open Reduction and Internal Fixation (ORIF)', 'Orthopedics', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (38, 8, 'Intra articular Injection ', 'Orthopedics ( Steriods/MSC)', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (39, 8, 'Closed Reduction/ Plaster of Paris (POP) /Scotchcast', 'Orthopedic Application ', NULL, '', '2023-05-20 14:39:21');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (41, 2, 'Home Consultation ', 'Consultation Alone ', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (42, 8, 'Catherization', 'Foleys or Silicone', NULL, '', '2023-05-20 15:43:14');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (43, 12, 'Medical Reports', 'Administrative | Medical | Legal', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (44, 2, 'Pharmacy', 'Medication,  IVFluids, etc', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (45, 3, 'Pharmacy 2', 'Medications, IVFluids, etc', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (46, 11, 'Plastic Surgery', 'Plastic Surgery', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 14:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 14:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 14:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 21:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-22 22:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-22 22:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-22 22:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (13, 'Nursing Services', 'no', 'yes', '2023-03-01 11:40:46');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 03:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 03:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 03:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 03:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 03:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 03:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 03:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 03:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 03:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 03:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 03:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 03:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 03:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 03:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 03:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 03:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 03:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 03:53:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (28, 13, 'opd', '2023-03-01 11:40:46');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (29, 13, 'ipd', '2023-03-01 11:40:46');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (30, 2, 'ipd', '2023-05-20 13:15:38');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (31, 2, 'pathology', '2023-05-20 13:15:39');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (32, 2, 'blood_bank', '2023-05-20 13:15:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (33, 2, 'radiology', '2023-05-20 13:15:43');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (34, 2, 'ambulance', '2023-05-20 13:15:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (35, 2, 'appointment', '2023-05-20 13:15:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (36, 3, 'appointment', '2023-05-20 13:15:51');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (38, 3, 'pathology', '2023-05-20 13:15:55');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (39, 3, 'radiology', '2023-05-20 13:15:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (40, 3, 'blood_bank', '2023-05-20 13:15:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (41, 3, 'ambulance', '2023-05-20 13:16:00');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (42, 4, 'appointment', '2023-05-20 13:16:40');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (43, 4, 'opd', '2023-05-20 13:16:41');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (44, 4, 'ipd', '2023-05-20 13:16:43');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (45, 4, 'radiology', '2023-05-20 13:16:46');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (46, 4, 'blood_bank', '2023-05-20 13:16:50');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (47, 4, 'ambulance', '2023-05-20 13:16:51');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (48, 5, 'appointment', '2023-05-20 13:16:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (49, 5, 'opd', '2023-05-20 13:16:58');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (50, 5, 'ipd', '2023-05-20 13:17:00');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (51, 5, 'pathology', '2023-05-20 13:17:02');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (52, 5, 'blood_bank', '2023-05-20 13:17:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (53, 5, 'ambulance', '2023-05-20 13:17:05');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (54, 8, 'appointment', '2023-05-20 13:17:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (55, 8, 'pathology', '2023-05-20 13:17:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (56, 8, 'radiology', '2023-05-20 13:17:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (57, 8, 'blood_bank', '2023-05-20 13:17:28');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (58, 8, 'ambulance', '2023-05-20 13:17:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (59, 9, 'ipd', '2023-05-20 13:17:36');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (60, 9, 'opd', '2023-05-20 13:17:37');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (61, 9, 'appointment', '2023-05-20 13:17:41');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (62, 11, 'appointment', '2023-05-20 13:17:48');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (63, 11, 'pathology', '2023-05-20 13:17:50');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (64, 11, 'radiology', '2023-05-20 13:17:51');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (65, 11, 'blood_bank', '2023-05-20 13:17:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (66, 11, 'ambulance', '2023-05-20 13:17:53');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (67, 13, 'ambulance', '2023-05-20 13:18:04');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'Per Exposure ', 0, '2023-02-04 08:19:59');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'Other', 0, '2023-03-01 11:42:31');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (3, 'Day', 0, '2023-03-20 11:27:58');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (4, '8-10 Clinic Visits', 0, '2023-03-23 13:05:06');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(10) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (1, 1, 1, 1, 'Chest X-ray AP/Lat', '7500.00', NULL, '', '', '2023-02-04 08:27:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (2, 2, 1, 1, 'Lumbosacral Spine X-ray ', '10000.00', NULL, '', '', '2023-02-04 08:34:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (3, 5, 1, 1, 'Orthopeadics ', '30000.00', NULL, '', '', '2023-03-20 10:41:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (4, 13, 1, 2, 'PCV', '1000.00', NULL, 'PCV and Hb measurements are considered as haematological indicators for classifying the severity of anaemia.', '', '2023-03-20 10:50:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (5, 3, 1, 2, 'OPD General Consultaion', '15000.00', NULL, 'General Consultaion', '', '2023-03-20 11:05:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (6, 13, 1, 2, 'Full Blood Count', '3000.00', NULL, 'Full Blood Count', '', '2023-03-23 10:54:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (7, 13, 1, 2, 'Genotype', '1500.00', NULL, 'genotype', '', '2023-03-24 10:41:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (8, 13, 1, 2, 'Blood grouping', '1500.00', NULL, 'blood grouping', '', '2023-03-24 10:44:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (9, 13, 1, 2, 'CLOTTING PROFILE', '9000.00', NULL, 'CLOTTING  PROFILE', '', '2023-03-24 10:48:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (10, 18, 1, 2, 'Erythropoietin', '40000.00', NULL, 'Erythropoietin', '', '2023-03-24 13:34:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (11, 21, 1, 2, 'Micro filaria', '1500.00', NULL, 'Micro filaria', '', '2023-03-24 13:38:00');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (12, 13, 1, 2, 'G- 6PD QUANTIFICATION', '18000.00', NULL, 'G- 6PD QUANTIFICATION', '', '2023-03-24 13:42:27');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (13, 13, 1, 2, 'Haemoglobin (HB)', '1000.00', NULL, 'Haemoglobin (HB)', '', '2023-03-24 13:43:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (14, 13, 1, 2, 'Plalelet count', '1500.00', NULL, 'Plalelet count', '', '2023-03-24 13:46:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 21, 1, 2, 'Malaria Parasite - Thick Film (MP)', '2000.00', NULL, 'Malaria Parasite - Thick Film (MP)', '', '2023-04-19 09:36:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 14, 1, 2, 'malaria parasites- RDT', '1000.00', NULL, 'Malaria parasites RDT', '', '2023-04-19 09:45:18');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (17, 14, 1, 2, 'Widal test', '2000.00', NULL, 'Widal test', '', '2023-04-19 09:48:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (18, 13, 1, 2, 'Fasting blood sugar (FBS)', '2000.00', NULL, 'Fasting blood sugar', '', '2023-04-19 10:00:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (19, 13, 1, 2, 'Random blood sugar (RBS)', '2000.00', NULL, 'Random blood sugar (RBS)', '', '2023-04-19 10:01:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (20, 18, 1, 2, 'Electrolyte, urea and creatinine test (EUCR)', '10000.00', NULL, 'Electrolyte, urea and creatinine test (EUCR)', '', '2023-04-19 10:04:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (21, 18, 1, 2, 'Liver function test (LFT)', '10000.00', NULL, 'Liver function test (LFT)', '', '2023-04-19 10:06:13');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (22, 18, 1, 2, 'Lipid profile', '10000.00', NULL, 'Lipid profile', '', '2023-04-19 10:07:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (23, 18, 1, 2, 'Uric acid', '3500.00', NULL, 'Uric acid', '', '2023-04-19 10:08:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (24, 20, 1, 2, 'High vaginal swab (HVS)', '7000.00', NULL, 'High vaginal swab (HVS)', '', '2023-04-19 10:10:24');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (25, 20, 1, 2, 'Endocervical swab (ECS)', '7000.00', NULL, 'Endocervical swab (ECS)', '', '2023-04-19 10:11:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (26, 14, 1, 2, 'Hepatitis screening (Hepatatis B)', '3000.00', NULL, 'Hepatitis screening (Hepatatis B)', '', '2023-04-19 10:15:26');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (27, 14, 1, 2, 'Hepatitis screening (Hepatatis C)', '3000.00', NULL, 'Hepatitis screening (Hepatatis C)', '', '2023-04-19 10:16:22');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (28, 14, 1, 2, 'Retroviral screening (RVS)', '3000.00', NULL, 'Retroviral screening (RVS)', '', '2023-04-19 10:17:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (29, 14, 1, 2, 'Venereal disease research laboratory (VDRL)', '3000.00', NULL, 'Venereal disease research laboratory (VDRL)', '', '2023-04-19 10:20:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (30, 13, 1, 2, 'Erythrocyte sedimentation rate (ESR)', '3000.00', NULL, 'Erythrocyte sedimentation rate (ESR)', '', '2023-04-19 10:22:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (31, 20, 1, 2, 'Urinalysis', '2000.00', NULL, 'Urinalysis', '', '2023-04-19 10:23:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (32, 20, 1, 2, 'Urine microscopy', '2000.00', NULL, 'urine microscopy', '', '2023-04-19 10:24:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (33, 20, 1, 2, 'Urine microscopy, culture and sensitivity', '7000.00', NULL, 'Urine microscopy, culture and sensitivity (Urine M/C/S)', '', '2023-04-19 10:26:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (34, 21, 1, 2, 'Stool microscopy', '2000.00', NULL, 'stool microscopy', '', '2023-04-19 10:27:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (35, 21, 1, 2, 'Stool microscopy, culture and sensitivity (stool m/c/s)', '7000.00', NULL, 'Stool microscopy, culture and sensitivity (stool m/c/s)', '', '2023-04-19 10:29:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (36, 21, 1, 2, 'Fecal occult blood (FOB)', '3000.00', NULL, 'Fecal occult blood (FOB)', '', '2023-04-19 10:31:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (37, 13, 1, 2, 'Glycated Hemoglobin (HbA1C)', '15000.00', NULL, 'Glycated Hemoglobin (HbA1C)', '', '2023-04-19 10:33:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (38, 14, 1, 2, 'Helicobacter pylori (H. pylori)', '3000.00', NULL, 'Helicobacter pylori (H. pylori)', '', '2023-04-19 10:35:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (39, 18, 1, 2, 'Prostate Serum Antigen (PSA)', '18000.00', NULL, 'Prostate Serum Antigen (PSA)', '', '2023-04-19 10:37:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (40, 16, 1, 2, 'Covid 19 immunity test', '20000.00', NULL, 'Covid 19 immunity test', '', '2023-04-19 10:39:07');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (41, 18, 1, 2, 'hormonal profile (5 panels)', '40000.00', NULL, 'hormonal profile (5 panels)', '', '2023-04-19 10:40:29');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (42, 18, 1, 2, 'Prolactin test', '8000.00', NULL, '', '', '2023-04-19 10:41:53');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (43, 18, 1, 2, 'Progesteron hormonal test', '8000.00', NULL, '', '', '2023-04-19 10:43:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (44, 18, 1, 2, 'Luteinizing hormone test (LH)', '8000.00', NULL, '', '', '2023-04-19 10:45:11');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (45, 18, 1, 2, 'Follicle-stimulating hormone test (FSH)', '8000.00', NULL, '', '', '2023-04-19 10:46:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (46, 18, 1, 2, 'Estradiol test (E2)', '8000.00', NULL, '', '', '2023-04-19 10:47:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (47, 18, 1, 2, 'Thyroid fuction test (T2, T3, T4, TSH)', '20000.00', NULL, '', '', '2023-04-19 10:50:50');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (48, 20, 1, 2, 'Wound swab', '7000.00', NULL, '', '', '2023-04-20 09:50:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (49, 20, 1, 2, 'Ear swab', '7000.00', NULL, '', '', '2023-04-20 09:51:25');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (50, 20, 1, 2, 'Throat swab', '7000.00', NULL, '', '', '2023-04-20 09:52:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (51, 20, 1, 2, 'Seminal Fluid Analysis (SFA)', '8000.00', NULL, '', '', '2023-04-20 09:54:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (52, 20, 1, 2, 'Blood culture', '15000.00', NULL, '', '', '2023-04-20 09:56:17');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (53, 24, 1, 2, 'Appointment Consultation', '10000.00', NULL, 'General Appointment Consultation', '', '2023-05-01 21:48:54');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (54, 4, 1, 2, 'General Consult Review', '5000.00', NULL, '', '', '2023-05-20 12:59:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (55, 7, 1, 2, 'Routine Admission', '50000.00', NULL, '1 to 2days regular treatment', '', '2023-05-20 13:11:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (56, 8, 1, 2, 'Major Minor', '100000.00', NULL, 'Major Minor', '', '2023-05-20 13:24:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (57, 9, 1, 2, 'Major Major', '1500000.00', NULL, 'Joint Replacement, Multiple Diseases in a Patient (Stroke +Hypetension+ Diabetis Mellitus + Coma ) Requiring Multiple specialists and or prolonged hospital stay', '', '2023-05-20 13:31:38');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (58, 25, 1, 2, 'Major', '300000.00', NULL, 'Requiring up to 1 week admission plus or minus a procedure', '', '2023-05-20 13:34:36');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (59, 26, 1, 1, 'Ceseraean Section ', '300000.00', NULL, 'Strictly for Surgical Fee', '', '2023-05-20 13:39:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (60, 27, 1, 2, 'Myomectomy', '500000.00', NULL, 'O & G Surgical Strictly for Procedure Alone', '', '2023-05-20 14:41:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (61, 28, 1, 2, 'Use of Theater Minor ', '50000.00', NULL, 'Minor Appendix, Lumpectomy, Hernia repair etc ', '', '2023-05-20 14:43:19');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (62, 28, 1, 2, 'Use of Theater Major', '100000.00', NULL, '', '', '2023-05-20 14:48:34');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (63, 28, 1, 2, 'Use of Theater (Major, Major)', '200000.00', NULL, 'oint Replacement Surgery, Multiple Surgeries In one , Certain Mymectomy Depending on Size', '', '2023-05-20 14:51:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (64, 30, 1, 2, 'Appendectomy', '150000.00', NULL, 'Strictly for Surgery Alone', '', '2023-05-20 14:53:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (65, 31, 1, 2, 'Herniotomy/Hernioplasty', '100000.00', NULL, 'Strictly for Surgery Alone ', '', '2023-05-20 14:56:01');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (66, 32, 1, 2, 'Lumpectomy', '75000.00', NULL, 'Strictly for Surgery Alone Under Local', '', '2023-05-20 14:56:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (67, 33, 1, 2, 'Circumcision Classical', '30000.00', NULL, '', '', '2023-05-20 14:58:39');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (68, 33, 1, 2, 'Circumcision Plastibel', '20000.00', NULL, '', '', '2023-05-20 14:59:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (69, 35, 1, 2, 'Total Hip Replacement', '3500000.00', NULL, 'Total Package', '', '2023-05-20 15:02:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (70, 36, 1, 2, 'Total Knee Replacement', '3500000.00', NULL, 'Total Package', '', '2023-05-20 15:08:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (71, 37, 1, 2, 'ORIF', '400000.00', NULL, 'Strictly For Procedure Alone', '', '2023-05-20 15:09:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (72, 38, 1, 2, 'Intra Artcular Injection (Steriods)', '75000.00', NULL, 'Per Dose ', '', '2023-05-20 15:11:15');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (73, 38, 1, 2, 'Inta Articular Injection ( MSC) Therapy', '700000.00', NULL, 'Total Package', '', '2023-05-20 15:12:44');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (74, 39, 1, 2, 'POP Minor ', '30000.00', NULL, 'Over one Joint ', '', '2023-05-20 15:14:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (75, 39, 1, 2, 'POP Moderate ', '50000.00', NULL, 'For the POP Alone', '', '2023-05-20 15:15:33');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (76, 39, 1, 2, 'POP Major', '120000.00', NULL, 'Across 2 more Joints Lower Limbs', '', '2023-05-20 15:18:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (77, 39, 1, 2, 'Scothcast Minor', '50000.00', NULL, 'Across one Joint (Cast Appilaction Alone )', '', '2023-05-20 15:19:52');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (78, 39, 1, 2, 'Scotchcast Moderate', '100000.00', NULL, '2 or More Joint Uper Limbs', '', '2023-05-20 15:21:03');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (79, 39, 1, 2, 'Scotchcast Major', '150000.00', NULL, 'Application of Cast Alone Across 2 more joints Lower Limb', '', '2023-05-20 15:22:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (80, 10, 1, 1, 'Wound Dressing (Minor)', '3000.00', NULL, 'Minor', '', '2023-05-20 15:25:21');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (81, 10, 1, 1, 'Wound Dressing (Major)', '5000.00', NULL, '', '', '2023-05-20 15:26:49');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (82, 41, 1, 1, 'Home Consultation ', '25000.00', NULL, 'Per Visit', '', '2023-05-20 15:29:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (83, 10, 1, 3, 'Nusring Medical/Day', '2000.00', NULL, '', '', '2023-05-20 15:31:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (84, 10, 1, 3, 'Nursing Surgical/Day', '3000.00', NULL, '', '', '2023-05-20 15:33:23');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (85, 42, 1, 1, 'Catherization without Sedation (Foleys)', '15000.00', NULL, 'Foleys', '', '2023-05-20 15:46:02');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (86, 42, 1, 3, 'Catherization without Sedation (Silicone)', '25000.00', NULL, 'Silicone', '', '2023-05-20 15:49:42');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (87, 43, 1, 2, 'Medical Report', '20000.00', NULL, '', '', '2023-05-20 15:52:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (88, 10, 1, 3, 'Consummables ', '3000.00', NULL, '', '', '2023-05-22 14:40:51');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (89, 46, 1, 1, 'Wound Debridement & Exploration', '150000.00', NULL, '', '', '2023-06-20 19:40:15');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'staff', 2, NULL, NULL, NULL, 0, '2023-02-03 13:09:27', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'staff', 1, NULL, 2, NULL, 0, '2023-02-03 13:09:27', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'patient', NULL, 3, NULL, NULL, 0, '2023-02-04 03:55:45', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'staff', 6, NULL, NULL, NULL, 0, '2023-02-10 09:54:17', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'staff', 9, NULL, 6, NULL, 0, '2023-02-10 09:54:17', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'staff', 7, NULL, NULL, NULL, 0, '2023-02-15 11:00:44', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'staff', 12, NULL, NULL, NULL, 0, '2023-05-20 12:50:33', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'staff', 4, NULL, 12, NULL, 0, '2023-05-20 12:50:33', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Billing discrepancies', '', '2023-02-03 06:17:10');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (2, 'Hospital Services', '', '2023-02-03 06:17:31');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (1, 21, '2023-06-05 17:32:00', '2023-06-05', 'Wound Debridement well done. Fresh bleeding seen. Necrotized fractured bone noticed, \r\nPatient Informed. FBC/MP Ordered .\r\nWound dressing to be done twice daily\r\n\r\nKnown Diabetic foot that had failed graft surgery done. Patient had been doing wound dressing at home using saturated salt water solution in th past 8 months. \r\nOn Examination Plantar foot wound lateral affecting both doral and platar laterally, Deep and foul smelling. Dressing soaked, and discolored. \r\nDressing doen using hydrogen peroxide and normal saline. Dressing daily for th 5 days and debrimor done for each day. \r\nThe glucose control is poor at 28mmol/dl on day 1 and 32 mmol/dl on day 2. Mixtard 100IU used in divided doses not effective. Then then on the day 3 Atrapid 60 IUIV, and 60IU IM used and the glucose while rehydrating with 1 litre of Normal Saline and 500ml of Ringers lactate. Glucose level came to 10.2 mmol/l . On Day 4 the Fasting Blood Sugar was 14mmol/l . and He had 500mls of Normal Saline with Bcomplex and IV ciprofloxacin. there was vomitting of undigested food eaten the previous day. Sugar level in the evevning was 17mmol/l and he had wound dressing and observation of of fractured nectoric bone was seen amidst fresh bleeding from surrounding soft tissue.', 12, '2023-06-05 16:35:32');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1, 21, 1, 'Known Diabetic foot that had failed graft surgery done. Patient had been doing wound dressing at home using saturated salt water solution in th past 8 months. \r\nOn Examination Plantar foot wound later', '2023-06-17 06:04:17');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `visible_on_patient_panel` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (1, 'Doctor\'s Note', 'ipd', 'textarea', 12, 0, '', 0, 0, 1, 0, NULL, 0, '2023-06-06 03:13:27');


#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `attachment` varchar(200) NOT NULL,
  `attachment_name` text DEFAULT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (1, 1131, 11, '', NULL, '2023-03-28 05:00:00', 'Mr Tavershima Adaa', '', 'yes', '2023-03-29 09:02:55');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (3, 2, 42, '', NULL, '2023-04-21 11:00:00', 'Alaribe Chinonye', 'Nil', 'yes', '2023-04-25 07:57:10');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (4, 50, 34, '', NULL, '2023-04-01 11:22:00', 'Badmus', 'Passed away at home', 'yes', '2023-05-23 10:23:24');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (5, 1153, 19, '', NULL, '2023-05-16 11:26:00', 'Isaac Augustine', 'Died at Home', 'yes', '2023-05-23 10:26:36');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'Administration & HR', 'yes', '2023-02-02 11:37:24');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (2, 'Diagnostics', 'yes', '2023-02-02 12:12:44');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (3, 'Nursing', 'yes', '2023-02-03 06:28:09');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (4, 'Security and Maintenance', 'yes', '2023-02-03 06:29:51');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (5, 'Surgery', 'yes', '2023-02-03 06:36:32');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (6, 'Psychiatry', 'yes', '2023-02-03 06:37:07');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (7, 'Finance', 'yes', '2023-02-03 06:37:31');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (8, 'Pharmacy', 'yes', '2023-02-03 06:39:45');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (9, 'General Medicine', 'yes', '2023-02-03 06:40:07');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (10, 'PHC - Jiwa', 'yes', '2023-02-03 06:40:54');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (11, 'Radiology', 'yes', '2023-02-03 06:41:14');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (12, 'Gynecology', 'yes', '2023-02-03 06:42:08');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (13, 'Business Development', 'yes', '2023-03-14 12:58:37');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(10) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text DEFAULT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 12, 2, '2023-03-20 12:49:33');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 12, 3, '2023-03-20 12:50:19');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (5, 9, 3, '2023-05-01 21:44:26');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (6, 12, 4, '2023-05-02 08:16:57');


#
# TABLE STRUCTURE FOR: doctor_shift
#

DROP TABLE IF EXISTS `doctor_shift`;

CREATE TABLE `doctor_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 9, 3, '08:00:00', '16:59:00', '2023-05-02 08:10:18');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (2, 'Tuesday', 9, 3, '08:00:00', '16:59:00', '2023-05-02 08:10:52');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (3, 'Wednesday', 9, 3, '08:00:00', '16:59:00', '2023-05-02 08:11:21');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (4, 'Thursday', 9, 3, '08:00:00', '16:59:00', '2023-05-02 08:12:11');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (5, 'Friday', 9, 3, '08:00:00', '12:30:00', '2023-05-02 08:12:58');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (6, 'Friday', 9, 3, '14:00:00', '16:59:00', '2023-05-02 08:13:24');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (7, 'Saturday', 9, 3, '09:00:00', '16:59:00', '2023-05-02 08:13:54');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (8, 'Monday', 12, 3, '08:00:00', '16:59:00', '2023-05-02 08:22:23');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (9, 'Friday', 12, 3, '10:00:00', '15:59:00', '2023-05-02 08:23:20');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (10, 'Thursday', 12, 3, '10:00:00', '16:59:00', '2023-05-02 08:24:11');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (11, 'Saturday', 12, 3, '13:00:00', '16:59:00', '2023-05-02 08:24:43');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (12, 'Wednesday', 12, 3, '10:00:00', '16:59:00', '2023-05-02 08:25:08');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (13, 'Tuesday', 12, 3, '10:00:00', '16:59:00', '2023-05-02 08:25:27');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (14, 'Monday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:26:08');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (15, 'Tuesday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:26:35');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (16, 'Wednesday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:26:58');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (17, 'Thursday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:27:16');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (18, 'Friday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:27:30');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (19, 'Saturday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:27:48');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (20, 'Sunday', 12, 2, '17:00:00', '23:59:00', '2023-05-02 08:28:06');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (8, '1 Day', '2023-05-03 18:40:18');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (9, '2 Days', '2023-05-03 18:40:32');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (10, '3 Days', '2023-05-03 18:40:51');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (11, '4 Days', '2023-05-03 18:41:02');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (12, '5 Days', '2023-05-03 18:41:10');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (13, '6 Days', '2023-05-03 18:41:23');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (14, '1 Week', '2023-05-03 18:41:35');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (15, '2 Weeks', '2023-05-03 18:41:48');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (16, '3 Weeks', '2023-05-03 18:41:55');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (17, '1 Month', '2023-05-03 18:42:08');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (18, '2 Months', '2023-05-03 18:42:19');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (19, '10 Days', '2023-05-20 16:48:06');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (20, 'X1 dose', '2023-05-21 12:49:17');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (21, 'X2 doses', '2023-05-21 12:49:31');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (22, 'X3 Doses', '2023-05-21 12:49:42');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (23, 'X4 Doses', '2023-05-21 12:49:53');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (24, 'X4 Doses', '2023-05-21 12:50:04');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (25, 'X6 Doses', '2023-05-21 12:50:14');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (26, 'X7 Doses', '2023-05-21 12:50:24');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (27, 'X8 doses', '2023-05-21 12:50:38');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (28, 'X9 Doses', '2023-05-21 12:50:47');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (29, 'X 10 Doses', '2023-05-21 12:51:01');


#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (1, 'Once daily', '2023-02-25 18:14:13');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (2, 'BD Daily', '2023-05-20 16:44:38');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (3, 'tds (3) daily', '2023-05-20 16:44:16');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (4, '6hrly', '2023-05-20 16:43:45');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (5, '4hrly', '2023-05-20 16:43:19');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (6, '12hrly', '2023-05-20 16:42:40');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (7, 'Stat', '2023-05-20 16:44:57');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (8, '8hrly', '2023-05-20 16:45:13');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'smtp', 'mail.kinectic.org', '587', 'portal@kinectic.org', 'cb_^e4OanEE1', '', 'true', 'yes', '2023-04-19 13:54:33');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Power AEDC', 'Grid Power', 'yes', 'no', '2023-05-20 18:02:57');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Power Fuel', 'Diesel', 'yes', 'no', '2023-05-20 18:03:20');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Power Repairs', 'Generator Service & Maintenance', 'yes', 'no', '2023-05-20 18:05:13');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Private Health Establishment Monitoring and Regula', '', 'yes', 'no', '2023-05-20 18:06:48');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (5, 'FCDA Water Board', '', 'yes', 'no', '2023-05-20 18:07:03');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (6, 'Abuja Environmental Protection Board (AEPB)', 'Waste Management', 'yes', 'no', '2023-05-20 18:08:08');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (7, 'Abuja Munical Area Council (AMAC)', '', 'yes', 'no', '2023-05-20 18:08:39');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (8, 'Cleaning & Laundary', '', 'yes', 'no', '2023-05-20 18:09:40');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (9, 'Facility Repairs and Maintenance', 'Doors\r\nLocks \r\nGate \r\nRoof \r\nPlumbing \r\nElectricals \r\n', 'yes', 'no', '2023-05-20 18:11:40');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (10, 'Information Technology', 'Software\r\nHardware\r\nData\r\nLaptop Repairs and Maintenance\r\nSMS Services \r\nVoice Calls', 'yes', 'no', '2023-05-20 18:16:36');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (11, 'Salary and Wages', '', 'yes', 'no', '2023-05-20 18:13:35');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (12, 'Consummables', 'Drugs & Medications \r\nGloves \r\nLaboratory Consummables\r\nSpirit \r\nCotton wool \r\n', 'yes', 'no', '2023-05-20 18:14:51');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (13, 'Medical Equipment', 'Repairs & Maintenance', 'yes', 'no', '2023-05-20 18:15:18');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `finding_category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (1, 'Ground Floor', '', '2023-02-03 06:47:13');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext DEFAULT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 03:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 5, 0, NULL, NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2023-04-19 13:52:07');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 03:18:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 10:54:41');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext DEFAULT NULL,
  `ext_url_link` mediumtext DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p>Home page first</p>', '0000-00-00', 1, 1, 'no', '2021-09-28 15:49:10');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 03:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 11:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 06:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 11:35:25');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` mediumtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_online_appointment` int(11) DEFAULT NULL,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext DEFAULT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, 1, NULL, NULL, './uploads/hospital_content/logo/front_logo-643fedd174bc42.03495460.png', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', './uploads/hospital_content/logo/front_fav_icon-643fedd174cc42.97143578.png', '2023-04-19 14:16:50');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'Night', '17:00:00', '23:59:00', '2023-05-01 21:41:41');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (3, 'Day', '08:00:00', '16:59:00', '2023-05-01 21:42:35');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (4, 'Early Morning', '00:00:00', '07:59:00', '2023-05-02 08:16:08');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` varchar(255) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (12, 'Consultation', '', 'yes', 'no', '2023-05-20 18:17:08');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (13, 'Admissions', '', 'yes', 'no', '2023-05-20 18:17:20');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (14, 'Drugs & Medication', '', 'yes', 'no', '2023-05-20 18:17:41');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (15, 'Procedures', '', 'yes', 'no', '2023-05-20 18:17:59');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (16, 'Nursing Services', '', 'yes', 'no', '2023-05-20 18:18:20');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (17, 'Pathology and Laboratory', '', 'yes', 'no', '2023-05-20 18:18:40');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (18, 'Medical Reports', '', 'yes', 'no', '2023-05-20 18:20:10');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (21, 'Out patient Department (OPD)', '', 'yes', 'no', '2023-05-20 18:40:50');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (22, 'In patient Department  (IPD)', '', 'yes', 'no', '2023-05-20 18:41:42');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` int(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (1, 186, 1, '', '83', '79', '36.8', '20', '120/90', '1', 1, 'Surgery Myomectomy', 'No', '', NULL, 'Yes', '', '', 9, 0, '20000', '', '2023-02-08 04:00:00', 'yes', 'no', 9, '2023-02-15 14:13:54');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (2, 257, 2, '', '65', '82', '36.6', '22', '110/70', '4', 2, 'Right Total Hip Replacement Surgery', 'No', 'Surgery', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-01-27 16:00:00', 'yes', 'no', 9, '2023-03-01 11:26:46');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (3, 258, 3, '', '15', '115', '36.8', '', '', '2', 1, 'Vomiting', 'Yes', 'Vomiting, Throat Pain', NULL, 'Yes', '', '', 9, 0, '20000', '', '2023-02-10 12:53:00', 'yes', 'no', 9, '2023-02-12 12:56:22');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (4, 314, 4, '', '', '', '', '', '', '1', 1, 'CS', 'No', 'Delivery', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-03-01 12:28:00', 'yes', 'no', 9, '2023-03-06 13:29:58');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (5, 887, 5, '', '1.3', '133', '36.9', '30', '', '4', 2, 'Sepsis', 'No', '', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-03-06 14:26:00', 'yes', 'no', 9, '2023-03-10 09:56:46');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (6, 314, 6, '', '', '', '', '', '', '2', 1, 'Gastroenteritis', 'No', '', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-03-07 11:08:00', 'yes', 'no', 9, '2023-03-10 09:18:01');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (7, 933, 7, '', '', '', '', '', '', '3', 1, 'Bleeding', 'Yes', '', NULL, '', NULL, '', 9, NULL, '100000', '', '2023-03-09 04:00:00', 'yes', 'no', 9, '2023-03-20 09:34:47');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (8, 955, 8, '', '', '92', '36.8', '26', '140/80', '2', 1, 'Malaria', 'No', '', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-03-11 02:00:00', 'yes', 'no', 9, '2023-03-29 09:06:13');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (9, 1151, 15, '', '2.1', '144', '', 'Spo2 99', '', '4', 2, 'Neonatal Sepsis', 'No', 'Neonatal Sepsis', NULL, 'Yes', 'SPo2 99-96 without oxygen. Placed on IV Ceftriazone, IV Gentamycin and strict monitoring and observation.', '', 9, 0, '20000', '', '2023-03-22 12:42:00', 'yes', 'no', 9, '2023-03-27 09:11:29');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (10, 1131, 24, '', '', '', '', '', '', '3', 1, 'Myomectomy', 'No', '', NULL, '', NULL, '', 12, NULL, '20000', '', '2023-03-27 10:11:00', 'yes', 'no', 9, '2023-03-29 09:04:46');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (11, 2, 42, '', '', '', '', '', '', '1', 1, 'TB', 'No', 'Tiredness, Low PCV', NULL, '', NULL, '', 12, NULL, '20000', '', '2023-04-13 08:13:00', 'yes', 'no', 9, '2023-04-25 07:57:10');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (12, 124, 43, '', '', '', '', '', '', '2', 1, '', 'No', 'Abdominal Pain', NULL, '', NULL, '', 12, NULL, '200000', '', '2023-04-10 08:13:00', 'yes', 'no', 9, '2023-04-25 07:58:11');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (13, 1350, 57, '', '110', '92', '36.6', '', '110/70', '4', 2, 'CS', 'No', 'For CS Thursday 20.4.23', NULL, 'Yes', 'Had CS done on Thursday 20/4/23 outcome Girl BW-2.9 good APGAR Score.', '', 9, 0, '20000', '', '2023-04-19 04:21:00', 'yes', 'no', 9, '2023-04-25 13:41:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (14, 955, 66, '', '68', '124', '36.5', '20', '100/70', '2', 1, 'Sepsis ? Cause with Anemia', 'No', 'Excess Salivation', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-04-25 14:44:00', 'yes', 'no', 9, '2023-05-01 11:01:52');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (15, 79, 74, '', '', '69', '36.4', '', '120/70', '1', 1, 'Chronic PUD', 'No', '', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-04-30 11:58:00', 'yes', 'no', 9, '2023-05-02 14:16:29');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (16, 315, 110, '', '', '', '', '', '', '4', 2, 'Elective CS', 'No', '', NULL, '', NULL, '', 12, NULL, '20000', '', '2023-05-08 12:40:00', 'yes', 'no', 9, '2023-05-21 12:14:12');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (17, 1717, 111, '', '', '82', '36.6', '', '110/80', '1', 1, 'RTA lone Survivor Pedestrian', 'Yes', 'Multiple Trauma Patient', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-05-09 12:40:00', 'yes', 'no', 9, '2023-05-23 17:14:30');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (18, 1920, 139, '', '63.7', '122', '37.8', '', '100/70', '3', 1, 'Post Chemoteraphy', 'No', 'Loose stool, Vomitting, Fever post chemoteraphy', 'Loose stool, Vomitting, Fever post chemoteraphy', '', ' Admit, FBC| MP| IVF 0.9N/Saline 500mls to alternate 5%D/Saline 8hrly x48hrs IV Acetaminophen 900mg 8hrly as Infusion X48hrs IV Vitamin Bcomplex 20mls 12hrly X48hrs IV Vitamin C 500mg 12hrly X48hrs IV Ciprofloxacin 200mg 12hrly X 48hrs IM CQ 200mg 12hrly X 5 doses Chross Match and tranfuse 2 pints of whole Blood Review after 48hrs', '', 9, 0, '20000', '', '2023-05-18 05:08:00', 'yes', 'no', 12, '2023-05-23 12:01:51');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (19, 2061, 155, '', '', '68', '36.6', '20', '120/90', '5', 1, 'Fainting', 'Yes', 'Sudden Fall at site, Sudden LOC for some minutes, Oriented in TPP, GCS 15/15.', 'Sudden Fall at site, Sudden LOC for some minutes, Oriented in TPP, GCS 15/15.', '', 'Short Admission', '', 9, 0, '20000', '', '2023-05-24 01:05:00', 'yes', 'no', 3, '2023-05-24 15:45:47');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (20, 313, 158, '', '', '91', '36.5', '22', '110/68', '4', 1, 'C/S', 'No', 'Contractions', NULL, '', NULL, '', 9, NULL, '20000', '', '2023-05-26 09:44:00', 'yes', 'no', 9, '2023-05-30 08:27:52');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `created_at`) VALUES (21, 98, 177, '', '', '84b/m', '36.7 Celsius (°C)', '22 c/m', '100/60mmHg', '5', 1, 'Diabetic Septic Foot', 'No', 'Diabetic Foot Ulcer Complications ', NULL, 'Yes', 'Known Diabetic foot that had failed graft surgery done. Patient had been doing wound dressing at home using saturated salt water solution in th past 8 months. \r\nOn Examination Plantar foot wound lateral affecting both doral and platar laterally, Deep and foul smelling. Dressing soaked, and discolored. \r\nDressing doen using hydrogen peroxide and normal saline. Dressing daily for th 5 days and debrimor done for each day. \r\nThe glucose control is poor at 28mmol/dl on day 1 and 32 mmol/dl on day 2. Mixtard 100IU used in divided doses not effective. Then then on the day 3 Atrapid 60 IUIV, and 60IU IM used and the glucose while rehydrating with 1 litre of Normal Saline and 500ml of Ringers lactate. Glucose level came to 10.2 mmol/l . On Day 4 the Fasting Blood Sugar was 14mmol/l . and He had 500mls of Normal Saline with Bcomplex and IV ciprofloxacin. there was vomitting of undigested food eaten the previous day. Sugar level in the evevning was 17mmol/l and he had wound dressing and observation of of fractured nectoric bone was seen amidst fresh bleeding from surrounding soft tissue.\r\n', '', 12, 0, '20000', '', '2023-06-02 12:42:00', 'no', 'no', 9, '2023-06-17 06:04:17');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (1, 20, 12, '2023-05-26 15:05:54');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `header_note` text DEFAULT NULL,
  `footer_note` text DEFAULT NULL,
  `finding_description` text DEFAULT NULL,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `prescribe_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (3, 18, NULL, '', '', '   ', 'yes', '2023-05-20', 12, 9, '2023-05-20 12:52:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (4, 18, NULL, '', '', '  ', 'yes', '2023-05-21', 3, 9, '2023-05-21 12:44:22');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (6, 20, NULL, '', '', ' ', NULL, '2023-05-26', 3, 12, '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (7, 21, NULL, '', '', ' ', 'yes', '2023-06-05', 3, 12, '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (8, NULL, 163, '', '', '  ', 'yes', '2023-06-09', 12, 12, '2023-06-09 11:14:57');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(10) DEFAULT NULL,
  `dosage` int(11) DEFAULT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (10, 3, 519, 1, 2, 10, '', '2023-05-20 12:48:34');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (16, 4, 218, 1, 1, 10, '', '2023-05-21 12:42:52');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (17, 4, 716, 7, 2, 10, '', '2023-05-21 12:44:22');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (23, 6, 245, 48, 6, 9, '', '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (24, 6, 197, 48, 8, 9, 'Paracetamol Infusion 900mg 8hrly', '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (25, 6, 198, 43, 6, 9, 'Diclofenac Infusion 75mg 12hrly', '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (26, 6, 437, 45, 6, 9, '', '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (27, 6, 716, 7, 0, 8, 'IVF 5%D?Saline 500mls 8hrly X 24hrs ', '2023-05-26 15:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (28, 7, 249, 45, 1, 10, '', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (29, 7, 986, 8, 1, 8, 'IVF 0.9N/Saline 1 Litre stat', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (30, 7, 520, 2, 2, 8, '', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (31, 7, 225, 2, 1, 12, 'IM chloroquine 200mg OD X 5days', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (32, 7, 263, 1, 1, 12, '', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (33, 7, 198, 43, 0, 12, 'IM Dclofenac 75mg  ODX5days', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (34, 7, 452, 60, 3, 12, '', '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (35, 8, 55, 16, 2, 14, '', '2023-06-09 11:09:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (36, 8, 61, 40, 2, 12, '', '2023-06-09 11:14:57');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (37, 8, 11, 32, 2, 12, '', '2023-06-09 11:14:57');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (38, 8, 789, 34, 1, 14, '', '2023-06-09 11:14:57');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (39, 8, 129, 36, 1, 14, '', '2023-06-09 11:14:57');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(100) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (8, 7, 1, NULL, '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (9, 7, 2, NULL, '2023-06-05 15:24:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (10, 8, 1, NULL, '2023-06-09 11:09:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (11, 8, 2, NULL, '2023-06-09 11:09:55');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text DEFAULT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'Chest Xray AP / Lateral', '2023-02-04 08:13:02');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'Ultrasound ', '2023-02-04 08:13:30');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (3, 'Skull Xary AP/Lateral', '2023-06-17 10:42:19');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (4, 'X-Ray Right Elbow Joint AP/Lateral', '2023-06-17 10:43:40');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (5, 'X-Ray Right Wrist Joint AP/Lateral', '2023-06-17 10:44:56');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (6, 'X-Ray Left Wrist Joint AP/Lateral', '2023-06-17 10:45:47');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (7, 'X-Ray  Left Elbow Joint AP/Lateral', '2023-06-17 10:46:25');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (8, 'Abdominal X-Ray  Erect/Supine', '2023-06-17 10:47:01');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (9, 'X-Ray Pelvis AP/Lateral', '2023-06-17 10:47:22');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (10, 'X-Ray Right Hip AP/Lateral', '2023-06-17 10:47:59');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (11, 'X-Ray Left Hip AP/Lateral', '2023-06-17 10:48:41');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (12, 'X-Ray Left Femur AP/Lateral', '2023-06-17 10:49:34');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (13, 'X-Ray Right Femur AP/Lateral', '2023-06-17 10:49:50');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (14, 'X-Ray Left Knee Joint AP/Lateral', '2023-06-17 10:50:22');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (15, 'X-Ray Right Knee Joint AP/Lateral', '2023-06-17 10:50:44');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (16, 'X-Ray Left Ankle Joint AP/Lateral', '2023-06-17 10:51:13');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (17, 'X-Ray Right Ankle Joint AP/Lateral', '2023-06-17 10:51:27');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 09:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 10:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 09:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 05:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 09:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 10:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 06:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 06:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 06:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 06:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 06:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 06:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 06:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 06:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 06:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 06:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 06:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 06:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 06:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 06:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 06:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 06:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 06:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 06:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 06:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 06:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 06:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 06:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 06:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 06:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 06:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 06:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 06:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 06:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 06:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 07:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 07:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 07:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 07:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 07:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 07:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 07:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 07:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 07:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 07:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 07:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 07:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 07:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 07:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 07:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 07:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 07:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 07:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 07:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 07:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 07:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 07:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 07:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 07:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 07:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 07:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 07:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 07:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 07:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 07:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 07:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 07:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 07:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 07:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 07:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 07:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 07:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 07:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 06:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia ', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 07:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 07:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 07:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (1, 'Sick leave', 'yes', '2023-02-03 06:45:06');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (2, 'Maternity Leave', 'yes', '2023-02-03 06:45:37');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (3, 'Paternity Leave', 'yes', '2023-02-03 06:45:56');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (4, 'Casual Leave', 'yes', '2023-02-03 06:46:08');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (5, 'Compulsory Leave', 'yes', '2023-05-10 15:11:25');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (6, 'Compassionate Leave', 'yes', '2023-05-10 15:12:18');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7042 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 10:49:19', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 10:50:56', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 10:54:18', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 11:22:35', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On Email Config id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:29:03', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'New Record inserted On Staff Designation id 1', 1, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:36:09', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On Staff Designation id 2', 2, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:36:33', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On Staff Designation id 3', 3, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:36:45', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On Staff Designation id 4', 4, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:37:03', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On Department id 1', 1, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:37:24', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'Record updated For Staff id 2', 2, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:39:08', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'Record updated Change Password For Staff id 2', 2, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:43:33', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'Record deleted On roles Permissions where Role id  8', 8, 1, 'Delete', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:45:54', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'Record updated On Email Config id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 12:47:03', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:03:19', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:07:07', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:09:13', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:10:04', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'Record updated On Settings id 1', 1, 1, 'Update', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:10:47', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On Department id 2', 2, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 13:12:44', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record deleted On Staff Designation id 4', 4, 1, 'Delete', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 14:04:10', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On Pathology Category id 1', 1, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:43:13', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On Pathology Category id 2', 2, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:43:43', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On Pathology Category id 3', 3, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:44:02', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On Pathology Category id 4', 4, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:45:33', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On Pathology Category id 5', 5, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:45:53', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Pathology Category id 6', 6, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:46:14', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'New Record inserted On Pathology Category id 7', 7, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:46:37', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On Pathology Category id 8', 8, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:46:59', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On Pathology Category id 9', 9, 1, 'Insert', '105.112.226.232', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-02 15:47:28', '2023-02-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'New Record inserted On Visitors Purpose id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:12:44', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On Visitors Purpose id 2', 2, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:12:58', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'New Record inserted On Visitors Purpose id 3', 3, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:13:14', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'New Record inserted On Visitors Purpose id 4', 4, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:13:29', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On Visitors Purpose id 5', 5, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:14:19', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On complaint_type id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:17:10', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On complaint_type id 2', 2, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:17:31', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'New Record inserted On Department id 3', 3, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:28:09', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'Record updated On Department id 1', 1, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:28:40', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On Department id 4', 4, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:29:51', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'New Record inserted On Department id 5', 5, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:36:32', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'New Record inserted On Department id 6', 6, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:37:07', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Department id 7', 7, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:37:31', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'New Record inserted On Department id 8', 8, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:39:45', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On Department id 9', 9, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:40:07', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'New Record inserted On Department id 10', 10, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:40:54', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'New Record inserted On Department id 11', 11, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:41:14', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'New Record inserted On Department id 12', 12, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:42:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'New Record inserted On Staff Designation id 5', 5, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:42:36', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'New Record inserted On Staff Designation id 6', 6, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:43:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On Staff Designation id 7', 7, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:43:27', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On Staff Designation id 8', 8, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:43:53', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On Staff Designation id 9', 9, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:44:19', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On Staff Designation id 10', 10, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:44:29', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted On Staff Designation id 11', 11, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:44:47', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On Leave Types id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:45:06', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Leave Types id 2', 2, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:45:37', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'New Record inserted On Leave Types id 3', 3, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:45:56', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On Leave Types id 4', 4, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:46:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Floor id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:47:13', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'New Record inserted On Bed Group id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:49:14', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Bed Group id 2', 2, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:49:31', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On Bed id 1', 1, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:51:37', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'Record updated On Bed id 1', 1, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:51:57', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Bed id 2', 2, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:52:17', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On Bed id 3', 3, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:52:37', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'New Record inserted On Bed id 4', 4, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:53:17', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'Record updated On Bed id 1', 1, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:53:41', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'Record updated On Bed id 2', 2, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:53:53', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'Record updated On Bed id 3', 3, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 07:54:07', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'Record updated On Bed id 3', 3, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 08:03:37', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'Record updated On Bed id 3', 3, 1, 'Update', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 08:03:49', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Chat Messages id 2', 2, 2, 'Insert', '105.112.120.131', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:10:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On Patient id 1', 1, 2, 'Insert', '105.112.120.131', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:32:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'Record updated On Patient id 1', 1, 2, 'Update', '105.112.120.131', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:32:08', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'New Record inserted On Chat Messages id 3', 3, 1, 'Insert', '105.112.120.131', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-03 14:32:28', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Patient id 2', 2, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:50:59', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On Patient id 2', 2, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:50:59', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On Patient id 3', 3, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:58:27', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'Record updated On Patient id 3', 3, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 14:58:27', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Patient id 4', 4, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:04:34', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record updated On Patient id 4', 4, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:04:34', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On Patient id 5', 5, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:13:51', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On Patient id 5', 5, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:13:51', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'New Record inserted On Patient id 6', 6, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:22:30', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record updated On Patient id 6', 6, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:22:30', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Patient id 7', 7, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:26:23', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'Record updated On Patient id 7', 7, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:26:23', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On Patient id 8', 8, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:28:38', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'Record updated On Patient id 8', 8, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:28:38', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On Patient id 9', 9, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:30:49', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'Record updated On Patient id 9', 9, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:30:49', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On Patient id 10', 10, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:32:56', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'Record updated On Patient id 10', 10, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:32:56', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Patient id 11', 11, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:46:41', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'Record updated On Patient id 11', 11, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:46:41', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On Patient id 12', 12, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:50:41', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On Patient id 12', 12, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:50:41', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On Patient id 13', 13, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:52:46', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'Record updated On Patient id 13', 13, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:52:46', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On Patient id 14', 14, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:56:00', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'Record updated On Patient id 14', 14, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:56:00', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted On Patient id 15', 15, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:59:38', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'Record updated On Patient id 15', 15, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 15:59:38', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On Patient id 16', 16, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 16:01:44', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On Patient id 16', 16, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 16:01:44', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On Patient id 17', 17, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 16:04:39', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On Patient id 17', 17, 2, 'Update', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 16:04:39', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On Chat Messages id 4', 4, 2, 'Insert', '105.112.113.59', 'Windows 10', 'Firefox 104.0', '2023-02-03 17:00:39', '2023-02-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'Record updated For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:36:17', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:11', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:11', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:11', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:11', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:11', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:12', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:12', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:13', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:13', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:14', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '105.112.113.59', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-04 04:38:33', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'New Record inserted On Lab id 1', 1, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:13:02', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'New Record inserted On Lab id 2', 2, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:13:30', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'New Record inserted On Charge Categories id 1', 1, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:18:01', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'New Record inserted On Tax Category id 1', 1, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:19:22', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'New Record inserted On Charge Units id 1', 1, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:19:59', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'New Record inserted On Charge Categories id 2', 2, 3, 'Insert', '105.112.113.248', 'Android', 'Chrome 108.0.0.0', '2023-02-04 09:31:39', '2023-02-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'New Record inserted On Patient id 18', 18, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:39:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record updated On Patient id 18', 18, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:39:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On Patient id 19', 19, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:42:32', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record updated On Patient id 19', 19, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:42:32', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'New Record inserted On Patient id 20', 20, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:49:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record updated On Patient id 20', 20, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:49:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On Patient id 21', 21, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:54:38', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record updated On Patient id 21', 21, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:54:38', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted On Patient id 22', 22, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:57:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'Record updated On Patient id 22', 22, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 08:57:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'New Record inserted On Patient id 23', 23, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:05:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'Record updated On Patient id 23', 23, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:05:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On Patient id 24', 24, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:06:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record updated On Patient id 24', 24, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:06:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On Patient id 25', 25, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:08:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record updated On Patient id 25', 25, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:08:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'New Record inserted On Patient id 26', 26, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:10:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record updated On Patient id 26', 26, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:10:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'New Record inserted On Patient id 27', 27, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:14:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record updated On Patient id 27', 27, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:14:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'New Record inserted On Patient id 28', 28, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:15:54', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record updated On Patient id 28', 28, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:15:54', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'New Record inserted On Patient id 29', 29, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:30:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'Record updated On Patient id 29', 29, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:30:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On Chat Messages id 6', 6, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:31:57', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'New Record inserted On Patient id 30', 30, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:55:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On Patient id 30', 30, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:55:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'New Record inserted On Patient id 31', 31, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:58:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record updated On Patient id 31', 31, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 09:58:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On Patient id 32', 32, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:00:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'Record updated On Patient id 32', 32, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:00:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'New Record inserted On Patient id 33', 33, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:01:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updated On Patient id 33', 33, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:01:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On Patient id 34', 34, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:05:10', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On Patient id 34', 34, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:05:10', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On Patient id 35', 35, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:07:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record updated On Patient id 35', 35, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:07:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On Patient id 36', 36, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:10:07', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'Record updated On Patient id 36', 36, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:10:07', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On Patient id 37', 37, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:13:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'Record updated On Patient id 37', 37, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:13:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On Patient id 38', 38, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:15:34', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'Record updated On Patient id 38', 38, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:15:34', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On Patient id 39', 39, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:23:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'Record updated On Patient id 39', 39, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:23:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On Patient id 40', 40, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:24:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'Record updated On Patient id 40', 40, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:24:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On Patient id 41', 41, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:26:54', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'Record updated On Patient id 41', 41, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:26:54', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On Patient id 42', 42, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:29:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record updated On Patient id 42', 42, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:29:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On Patient id 43', 43, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:33:05', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'Record updated On Patient id 43', 43, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:33:05', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On Patient id 44', 44, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:38:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On Patient id 44', 44, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:38:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On Patient id 45', 45, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:41:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record updated On Patient id 45', 45, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:41:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On Patient id 46', 46, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:45:29', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record updated On Patient id 46', 46, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:45:29', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On Patient id 47', 47, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:47:40', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'Record updated On Patient id 47', 47, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:47:40', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On Patient id 48', 48, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:48:43', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'Record updated On Patient id 48', 48, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:48:43', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On Patient id 49', 49, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:51:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record updated On Patient id 49', 49, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:51:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On Patient id 50', 50, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:54:18', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'Record updated On Patient id 50', 50, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:54:18', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'New Record inserted On Patient id 51', 51, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:56:11', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'Record updated On Patient id 51', 51, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:56:11', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On Patient id 52', 52, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:57:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'Record updated On Patient id 52', 52, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 10:57:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On Patient id 53', 53, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:02:53', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'Record updated On Patient id 53', 53, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:02:53', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Patient id 54', 54, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:41:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'Record updated On Patient id 54', 54, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:41:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On Patient id 55', 55, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:44:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'Record updated On Patient id 55', 55, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:44:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On Patient id 56', 56, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:48:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated On Patient id 56', 56, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:48:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On Patient id 57', 57, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:53:16', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'Record updated On Patient id 57', 57, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:53:16', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On Patient id 58', 58, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:55:46', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updated On Patient id 58', 58, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:55:46', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'New Record inserted On Patient id 59', 59, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:59:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'Record updated On Patient id 59', 59, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 11:59:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On Patient id 60', 60, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:00:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record updated On Patient id 60', 60, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:00:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On Patient id 61', 61, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:03:21', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'Record updated On Patient id 61', 61, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:03:21', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On Patient id 62', 62, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:05:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated On Patient id 62', 62, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:05:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On Patient id 63', 63, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:07:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'Record updated On Patient id 63', 63, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:07:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On Patient id 64', 64, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:09:35', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'Record updated On Patient id 64', 64, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:09:35', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'New Record inserted On Patient id 65', 65, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:12:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'Record updated On Patient id 65', 65, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:12:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'New Record inserted On Patient id 66', 66, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:16:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'Record updated On Patient id 66', 66, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:16:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On Patient id 67', 67, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:18:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'Record updated On Patient id 67', 67, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:18:19', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On Patient id 68', 68, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:20:01', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'Record updated On Patient id 68', 68, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:20:01', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'New Record inserted On Patient id 69', 69, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:23:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated On Patient id 69', 69, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:23:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On Patient id 70', 70, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:24:52', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On Patient id 70', 70, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:24:52', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On Patient id 71', 71, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:27:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated On Patient id 71', 71, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:27:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On Patient id 72', 72, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:29:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'Record updated On Patient id 72', 72, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:29:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On Patient id 73', 73, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:31:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'Record updated On Patient id 73', 73, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:31:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On Patient id 74', 74, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:33:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'Record updated On Patient id 74', 74, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:33:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On Patient id 75', 75, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:35:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record updated On Patient id 75', 75, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 12:35:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On Patient id 76', 76, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:38:50', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record updated On Patient id 76', 76, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:38:50', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'New Record inserted On Patient id 77', 77, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:40:23', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'Record updated On Patient id 77', 77, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:40:23', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On Patient id 78', 78, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:44:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'Record updated On Patient id 78', 78, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:44:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On Patient id 79', 79, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:49:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'Record updated On Patient id 79', 79, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:49:27', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On Patient id 80', 80, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:51:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated On Patient id 80', 80, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:51:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On Patient id 81', 81, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:54:05', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'Record updated On Patient id 81', 81, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:54:05', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On Patient id 82', 82, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:56:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'Record updated On Patient id 82', 82, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:56:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'New Record inserted On Patient id 83', 83, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:58:25', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated On Patient id 83', 83, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 13:58:25', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'New Record inserted On Patient id 84', 84, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:02:39', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record updated On Patient id 84', 84, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:02:39', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On Patient id 85', 85, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:04:11', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'Record updated On Patient id 85', 85, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:04:11', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On Patient id 86', 86, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:07:23', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'Record updated On Patient id 86', 86, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:07:23', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'New Record inserted On Patient id 87', 87, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:10:08', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'Record updated On Patient id 87', 87, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:10:08', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On Patient id 88', 88, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:12:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'Record updated On Patient id 88', 88, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:12:24', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'New Record inserted On Patient id 89', 89, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:14:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated On Patient id 89', 89, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:14:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On Patient id 90', 90, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:18:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On Patient id 90', 90, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:18:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On Patient id 91', 91, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:21:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'Record updated On Patient id 91', 91, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:21:03', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'New Record inserted On Patient id 92', 92, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:24:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'Record updated On Patient id 92', 92, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:24:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'New Record inserted On Patient id 93', 93, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:32:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'Record updated On Patient id 93', 93, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:32:04', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Patient id 94', 94, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:33:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'Record updated On Patient id 94', 94, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:33:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On Patient id 95', 95, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:35:57', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record updated On Patient id 95', 95, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:35:57', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'New Record inserted On Patient id 96', 96, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:39:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'Record updated On Patient id 96', 96, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:39:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'New Record inserted On Patient id 97', 97, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:40:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'Record updated On Patient id 97', 97, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:40:48', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On Patient id 98', 98, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:42:49', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'Record updated On Patient id 98', 98, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:42:49', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On Patient id 99', 99, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:44:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'Record updated On Patient id 99', 99, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:44:47', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'New Record inserted On Patient id 100', 100, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:47:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record updated On Patient id 100', 100, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:47:31', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'New Record inserted On Patient id 101', 101, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:49:37', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record updated On Patient id 101', 101, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:49:37', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'New Record inserted On Patient id 102', 102, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:53:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record updated On Patient id 102', 102, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:53:44', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'New Record inserted On Patient id 103', 103, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:56:13', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'Record updated On Patient id 103', 103, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:56:13', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'New Record inserted On Patient id 104', 104, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:59:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record updated On Patient id 104', 104, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 14:59:15', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On Patient id 105', 105, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:03:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'Record updated On Patient id 105', 105, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:03:06', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On Patient id 106', 106, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:04:39', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'Record updated On Patient id 106', 106, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:04:39', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On Patient id 107', 107, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:06:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'Record updated On Patient id 107', 107, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:06:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'New Record inserted On Patient id 108', 108, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:09:02', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record updated On Patient id 108', 108, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:09:02', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'New Record inserted On Patient id 109', 109, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:12:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'Record updated On Patient id 109', 109, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:12:42', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On Patient id 110', 110, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:14:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'Record updated On Patient id 110', 110, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:14:14', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On Patient id 111', 111, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:15:26', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'Record updated On Patient id 111', 111, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:15:26', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'New Record inserted On Patient id 112', 112, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:18:20', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'Record updated On Patient id 112', 112, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:18:20', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'New Record inserted On Patient id 113', 113, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:19:18', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'Record updated On Patient id 113', 113, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:19:18', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'New Record inserted On Patient id 114', 114, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:21:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record updated On Patient id 114', 114, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:21:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'New Record inserted On Patient id 115', 115, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:24:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'Record updated On Patient id 115', 115, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:24:22', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On Patient id 116', 116, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:26:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'Record updated On Patient id 116', 116, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:26:36', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On Patient id 117', 117, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:27:37', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'Record updated On Patient id 117', 117, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:27:37', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On Patient id 118', 118, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:30:16', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'Record updated On Patient id 118', 118, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:30:16', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'New Record inserted On Patient id 119', 119, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:31:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'Record updated On Patient id 119', 119, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:31:58', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On Patient id 120', 120, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:33:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'Record updated On Patient id 120', 120, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:33:33', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On Patient id 121', 121, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:36:59', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'Record updated On Patient id 121', 121, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:36:59', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'New Record inserted On Patient id 122', 122, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:38:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated On Patient id 122', 122, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:38:41', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On Patient id 123', 123, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:41:08', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'Record updated On Patient id 123', 123, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:41:08', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'New Record inserted On Patient id 124', 124, 2, 'Insert', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:48:21', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'Record updated On Patient id 124', 124, 2, 'Update', '105.112.116.85', 'Windows 10', 'Firefox 109.0', '2023-02-06 15:48:21', '2023-02-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'New Record inserted On Staff Designation id 12', 12, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 14:43:35', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'New Record inserted On Staff Designation id 13', 13, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 14:44:48', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted On Staff Designation id 14', 14, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 14:45:05', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'Record updated For Staff id 4', 4, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 14:50:05', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'Record updated For Staff id 5', 5, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 14:59:01', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'Record updated For Staff id 6', 6, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:03:15', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'Record updated For Staff id 7', 7, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:20:11', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'New Record inserted On Staff Designation id 15', 15, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:23:21', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'Record updated On Staff Designation id 15', 15, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:23:44', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'Record updated For Staff id 8', 8, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:28:07', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'New Record inserted On Staff Designation id 16', 16, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:30:32', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'Record updated On Staff Designation id 8', 8, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:30:59', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'New Record inserted On Staff Designation id 17', 17, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:31:43', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'New Record inserted On Staff Designation id 18', 18, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:33:21', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'New Record inserted On Staff Designation id 19', 19, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:34:22', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'New Record inserted On Staff Designation id 20', 20, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:35:08', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On Staff Designation id 21', 21, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:35:51', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'New Record inserted On Staff Designation id 22', 22, 3, 'Insert', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:36:26', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated For Staff id 9', 9, 3, 'Update', '105.112.230.130', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 15:47:55', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On Roles id 10', 10, 1, 'Insert', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:15:36', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On Roles id 11', 11, 1, 'Insert', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:15:55', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'Record updated Change Password For Staff id 9', 9, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:34:41', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'Record updated Change Password For Staff id 5', 5, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:37:19', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'Record updated For Staff id 8', 8, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:39:36', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'Record updated For Staff id 8', 8, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:39:36', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'Record updated For Staff id 5', 5, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:41:56', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'Record updated For Staff id 5', 5, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:41:56', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 16:59:32', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record updated Change Password For Staff id 7', 7, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 17:01:28', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 17:02:35', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'Record updated Change Password For Staff id 9', 9, 1, 'Update', '105.112.115.49', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-07 17:04:27', '2023-02-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '105.112.112.209', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-08 13:38:38', '2023-02-08');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On Patient id 125', 125, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:39:33', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'Record updated On Patient id 125', 125, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:39:33', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'New Record inserted On Patient id 126', 126, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:41:46', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated On Patient id 126', 126, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:41:46', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'New Record inserted On Patient id 127', 127, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:43:28', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record updated On Patient id 127', 127, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:43:28', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'New Record inserted On Patient id 128', 128, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:54:37', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'Record updated On Patient id 128', 128, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 08:54:37', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On Patient id 129', 129, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:05:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'Record updated On Patient id 129', 129, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:05:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'New Record inserted On Patient id 130', 130, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:07:04', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'Record updated On Patient id 130', 130, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:07:04', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'New Record inserted On Patient id 131', 131, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:12:07', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'Record updated On Patient id 131', 131, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:12:07', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On Patient id 132', 132, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:14:43', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'Record updated On Patient id 132', 132, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:14:43', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'New Record inserted On Patient id 133', 133, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:18:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'Record updated On Patient id 133', 133, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:18:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'New Record inserted On Patient id 134', 134, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:21:43', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'Record updated On Patient id 134', 134, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:21:43', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'New Record inserted On Patient id 135', 135, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:23:02', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'Record updated On Patient id 135', 135, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:23:02', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'New Record inserted On Patient id 136', 136, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:24:36', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'Record updated On Patient id 136', 136, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:24:36', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'New Record inserted On Patient id 137', 137, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:27:59', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'Record updated On Patient id 137', 137, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:27:59', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'New Record inserted On Patient id 138', 138, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:30:41', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'Record updated On Patient id 138', 138, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:30:41', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On Patient id 139', 139, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:31:57', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'Record updated On Patient id 139', 139, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:31:57', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'New Record inserted On Patient id 140', 140, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:34:35', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'Record updated On Patient id 140', 140, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:34:35', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On Patient id 141', 141, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:38:14', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'Record updated On Patient id 141', 141, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:38:14', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'New Record inserted On Patient id 142', 142, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:40:39', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'Record updated On Patient id 142', 142, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:40:39', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'New Record inserted On Patient id 143', 143, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:42:32', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'Record updated On Patient id 143', 143, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:42:32', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted On Patient id 144', 144, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:44:17', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'Record updated On Patient id 144', 144, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:44:17', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On Patient id 145', 145, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:47:17', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'Record updated On Patient id 145', 145, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:47:17', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'New Record inserted On Patient id 146', 146, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:49:23', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'Record updated On Patient id 146', 146, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:49:23', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'New Record inserted On Patient id 147', 147, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:51:18', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'Record updated On Patient id 147', 147, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:51:18', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'New Record inserted On Patient id 148', 148, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:53:02', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'Record updated On Patient id 148', 148, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:53:02', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'New Record inserted On Patient id 149', 149, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:55:22', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'Record updated On Patient id 149', 149, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:55:22', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'New Record inserted On Patient id 150', 150, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:57:27', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'Record updated On Patient id 150', 150, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:57:27', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record inserted On Patient id 151', 151, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:59:23', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'Record updated On Patient id 151', 151, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 09:59:23', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'New Record inserted On Patient id 152', 152, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:00:28', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'Record updated On Patient id 152', 152, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:00:28', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'New Record inserted On Patient id 153', 153, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:02:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'Record updated On Patient id 153', 153, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:02:10', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On Patient id 154', 154, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:03:19', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'Record updated On Patient id 154', 154, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:03:19', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On Patient id 155', 155, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:04:57', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'Record updated On Patient id 155', 155, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:04:57', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'New Record inserted On Patient id 156', 156, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:06:01', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'Record updated On Patient id 156', 156, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:06:01', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'New Record inserted On Patient id 157', 157, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:11:39', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'Record updated On Patient id 157', 157, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:11:39', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'New Record inserted On Patient id 158', 158, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:15:58', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'Record updated On Patient id 158', 158, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:15:58', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'New Record inserted On Patient id 159', 159, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:18:06', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'Record updated On Patient id 159', 159, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:18:06', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'New Record inserted On Patient id 160', 160, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:25:37', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On Patient id 160', 160, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:25:37', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'New Record inserted On Patient id 161', 161, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:30:30', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'Record updated On Patient id 161', 161, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:30:30', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'New Record inserted On Patient id 162', 162, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:33:09', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'Record updated On Patient id 162', 162, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:33:09', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'New Record inserted On Patient id 163', 163, 2, 'Insert', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:36:50', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'Record updated On Patient id 163', 163, 2, 'Update', '105.112.112.204', 'Windows 10', 'Firefox 109.0', '2023-02-09 10:36:50', '2023-02-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On Patient id 164', 164, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:47:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'Record updated On Patient id 164', 164, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:47:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On Patient id 165', 165, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:53:28', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record updated On Patient id 165', 165, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:53:28', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'New Record inserted On Patient id 166', 166, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:56:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'Record updated On Patient id 166', 166, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 08:56:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On Patient id 167', 167, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:00:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'Record updated On Patient id 167', 167, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:00:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'New Record inserted On Patient id 168', 168, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:16:22', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'Record updated On Patient id 168', 168, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:16:22', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'New Record inserted On Patient id 169', 169, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:18:04', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'Record updated On Patient id 169', 169, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:18:04', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On Patient id 170', 170, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:52:38', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'Record updated On Patient id 170', 170, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:52:38', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'New Record inserted On Patient id 171', 171, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:54:05', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'Record updated On Patient id 171', 171, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:54:05', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'New Record inserted On Patient id 172', 172, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:55:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'Record updated On Patient id 172', 172, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:55:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'New Record inserted On Patient id 173', 173, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:56:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'Record updated On Patient id 173', 173, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:56:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'New Record inserted On Patient id 174', 174, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:57:28', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'Record updated On Patient id 174', 174, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:57:28', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'New Record inserted On Patient id 175', 175, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:59:58', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On Patient id 175', 175, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 09:59:58', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'New Record inserted On Patient id 176', 176, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:09:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'Record updated On Patient id 176', 176, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:09:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On Patient id 177', 177, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:12:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'Record updated On Patient id 177', 177, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:12:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'New Record inserted On Patient id 178', 178, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:14:20', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'Record updated On Patient id 178', 178, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:14:20', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'New Record inserted On Patient id 179', 179, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:16:03', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'Record updated On Patient id 179', 179, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:16:03', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'New Record inserted On Patient id 180', 180, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:20:47', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'Record updated On Patient id 180', 180, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:20:47', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'New Record inserted On Patient id 181', 181, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:24:41', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'Record updated On Patient id 181', 181, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:24:41', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On Patient id 182', 182, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:26:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'Record updated On Patient id 182', 182, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:26:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'New Record inserted On Patient id 183', 183, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:28:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'Record updated On Patient id 183', 183, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:28:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'New Record inserted On Patient id 184', 184, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:30:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'Record updated On Patient id 184', 184, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:30:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'New Record inserted On Patient id 185', 185, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:32:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'Record updated On Patient id 185', 185, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:32:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'New Record inserted On Patient id 186', 186, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:33:04', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'Record updated On Patient id 186', 186, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:33:04', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record inserted On Patient id 187', 187, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:34:12', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'Record updated On Patient id 187', 187, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:34:12', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'New Record inserted On Patient id 188', 188, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:35:14', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'Record updated On Patient id 188', 188, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:35:14', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'New Record inserted On Patient id 189', 189, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:36:27', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'Record updated On Patient id 189', 189, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:36:27', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On Patient id 190', 190, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:38:42', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On Patient id 190', 190, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:38:42', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'New Record inserted On Patient id 191', 191, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:40:49', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'Record updated On Patient id 191', 191, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:40:49', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On Patient id 192', 192, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:41:18', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'Record updated On Patient id 192', 192, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:41:18', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'New Record inserted On Patient id 193', 193, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:44:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'Record updated On Patient id 193', 193, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:44:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'Record updated On Patient id 193', 193, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:45:30', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On Patient id 194', 194, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:46:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'Record updated On Patient id 194', 194, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:46:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'New Record inserted On Patient id 195', 195, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:50:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'Record updated On Patient id 195', 195, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:50:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'New Record inserted On Patient id 196', 196, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:52:01', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'Record updated On Patient id 196', 196, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:52:01', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'New Record inserted On Patient id 197', 197, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:54:40', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'Record updated On Patient id 197', 197, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:54:40', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'New Record inserted On Patient id 198', 198, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:56:27', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'Record updated On Patient id 198', 198, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:56:27', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On Patient id 199', 199, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:58:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'Record updated On Patient id 199', 199, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 10:58:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'New Record inserted On Patient id 200', 200, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:59:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'Record updated On Patient id 200', 200, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 10:59:25', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On Patient id 201', 201, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:01:34', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'Record updated On Patient id 201', 201, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:01:34', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'New Record inserted On Patient id 202', 202, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:02:08', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'Record updated On Patient id 202', 202, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:02:08', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'New Record inserted On Patient id 203', 203, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:03:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'Record updated On Patient id 203', 203, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:03:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'New Record inserted On Patient id 204', 204, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:04:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'Record updated On Patient id 204', 204, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:04:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On Patient id 205', 205, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:05:06', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'Record updated On Patient id 205', 205, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:05:06', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On Patient id 206', 206, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:06:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'Record updated On Patient id 206', 206, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:06:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On Patient id 207', 207, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:07:32', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'Record updated On Patient id 207', 207, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:07:32', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'New Record inserted On Patient id 208', 208, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:07:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'Record updated On Patient id 208', 208, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 11:07:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On Patient id 209', 209, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:08:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'Record updated On Patient id 209', 209, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:08:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'New Record inserted On Patient id 210', 210, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:09:49', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record updated On Patient id 210', 210, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:09:49', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'New Record inserted On Patient id 211', 211, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:11:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'Record updated On Patient id 211', 211, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:11:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'New Record inserted On Patient id 212', 212, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:14:38', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'Record updated On Patient id 212', 212, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:14:38', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'New Record inserted On Patient id 213', 213, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:16:10', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'Record updated On Patient id 213', 213, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:16:10', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'New Record inserted On Patient id 214', 214, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:19:29', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'Record updated On Patient id 214', 214, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:19:29', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'New Record inserted On Patient id 215', 215, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:21:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'Record updated On Patient id 215', 215, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:21:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'New Record inserted On Patient id 216', 216, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:22:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'Record updated On Patient id 216', 216, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:22:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'New Record inserted On Patient id 217', 217, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:25:47', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'Record updated On Patient id 217', 217, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:25:47', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'New Record inserted On Patient id 218', 218, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:27:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'Record updated On Patient id 218', 218, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:27:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'New Record inserted On Patient id 219', 219, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:29:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'Record updated On Patient id 219', 219, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:29:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'New Record inserted On Patient id 220', 220, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:30:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'Record updated On Patient id 220', 220, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:30:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'New Record inserted On Patient id 221', 221, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:32:42', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'Record updated On Patient id 221', 221, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:32:42', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'New Record inserted On Patient id 222', 222, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:36:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'Record updated On Patient id 222', 222, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:36:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'New Record inserted On Patient id 223', 223, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:39:13', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'Record updated On Patient id 223', 223, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:39:13', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On Patient id 224', 224, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:40:26', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'Record updated On Patient id 224', 224, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:40:26', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'New Record inserted On Patient id 225', 225, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:46:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'Record updated On Patient id 225', 225, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:46:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On Patient id 226', 226, 2, 'Insert', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:47:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'Record updated On Patient id 226', 226, 2, 'Update', '105.112.225.135', 'Windows 10', 'Firefox 109.0', '2023-02-10 11:47:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'New Record inserted On Patient id 227', 227, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:11:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'Record updated On Patient id 227', 227, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:11:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'New Record inserted On Patient id 228', 228, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:13:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'Record updated On Patient id 228', 228, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:13:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'New Record inserted On Patient id 229', 229, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:14:30', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'Record updated On Patient id 229', 229, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:14:30', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'New Record inserted On IPD id 1', 1, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:19:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'Record updated On Bed id 1', 1, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:19:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'New Record inserted On Patient bed history id 1', 1, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:19:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On Patient id 230', 230, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:22:10', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'Record updated On Patient id 230', 230, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:22:10', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'New Record inserted On Patient id 231', 231, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:23:33', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'Record updated On Patient id 231', 231, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:23:33', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'New Record inserted On Patient id 232', 232, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:25:11', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'Record updated On Patient id 232', 232, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:25:11', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On Patient id 233', 233, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:26:32', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'Record updated On Patient id 233', 233, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:26:32', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'New Record inserted On Patient id 234', 234, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:27:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'Record updated On Patient id 234', 234, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:27:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'New Record inserted On Patient id 235', 235, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:29:06', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'Record updated On Patient id 235', 235, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:29:06', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'New Record inserted On Patient id 236', 236, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:30:31', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'Record updated On Patient id 236', 236, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:30:31', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On Patient id 237', 237, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:33:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'Record updated On Patient id 237', 237, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:33:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On Patient id 238', 238, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:34:58', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'Record updated On Patient id 238', 238, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:34:58', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On Patient id 239', 239, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:35:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'Record updated On Patient id 239', 239, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:35:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On Patient id 240', 240, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:36:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'Record updated On Patient id 240', 240, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:36:54', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On Patient id 241', 241, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:38:09', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'Record updated On Patient id 241', 241, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:38:09', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On Patient id 242', 242, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:40:16', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'Record updated On Patient id 242', 242, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:40:16', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On Patient id 243', 243, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:41:26', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'Record updated On Patient id 243', 243, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:41:26', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On Patient id 244', 244, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:42:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'Record updated On Patient id 244', 244, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:42:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'New Record inserted On Patient id 245', 245, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:44:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'Record updated On Patient id 245', 245, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:44:51', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'New Record inserted On Patient id 246', 246, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:46:02', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'Record updated On Patient id 246', 246, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:46:02', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'New Record inserted On Patient id 247', 247, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:47:43', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'Record updated On Patient id 247', 247, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:47:43', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'New Record inserted On Patient id 248', 248, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:50:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'Record updated On Patient id 248', 248, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 12:50:48', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 13:35:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 13:35:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 13:36:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 13:36:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'New Record inserted On Patient id 249', 249, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:04:20', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'Record updated On Patient id 249', 249, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:04:20', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'New Record inserted On Patient id 250', 250, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:25:40', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'Record updated On Patient id 250', 250, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:25:40', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'New Record inserted On Patient id 251', 251, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:26:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'Record updated On Patient id 251', 251, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:26:46', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On Patient id 252', 252, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:27:53', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'Record updated On Patient id 252', 252, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:27:53', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'New Record inserted On Patient id 253', 253, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:30:02', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'Record updated On Patient id 253', 253, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:30:02', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On Patient id 254', 254, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:32:16', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'Record updated On Patient id 254', 254, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:32:16', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On Patient id 255', 255, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:33:19', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'Record updated On Patient id 255', 255, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:33:19', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'New Record inserted On Patient id 256', 256, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:34:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'Record updated On Patient id 256', 256, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:34:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:34:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'Record updated On Print Setting id 1', 1, 1, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:34:59', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'New Record inserted On Patient id 257', 257, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:39:34', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'Record updated On Patient id 257', 257, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:39:34', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'New Record inserted On IPD id 2', 2, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:42:03', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'Record updated On Bed id 4', 4, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:42:03', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On Patient bed history id 2', 2, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:42:03', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'New Record inserted On Patient id 258', 258, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:44:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'Record updated On Patient id 258', 258, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:44:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'New Record inserted On IPD id 3', 3, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:47:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record updated On Bed id 2', 2, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:47:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'New Record inserted On Patient bed history id 3', 3, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:47:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'New Record inserted On Read System Notification id 1', 1, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:48:12', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On Read System Notification id 2', 2, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:48:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On Read System Notification id 3', 3, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:48:17', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On Patient id 259', 259, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:51:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'Record updated On Patient id 259', 259, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:51:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'New Record inserted On Patient id 260', 260, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:54:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'Record updated On Patient id 260', 260, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:54:35', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'New Record inserted On Patient id 261', 261, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:56:24', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'Record updated On Patient id 261', 261, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 14:56:24', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On Patient id 262', 262, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:05:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'Record updated On Patient id 262', 262, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:05:15', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'New Record inserted On Patient id 263', 263, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:07:33', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'Record updated On Patient id 263', 263, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:07:33', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'New Record inserted On Patient id 264', 264, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:08:43', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'Record updated On Patient id 264', 264, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:08:43', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'New Record inserted On Patient id 265', 265, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:09:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'Record updated On Patient id 265', 265, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:09:55', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On Patient id 266', 266, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:11:00', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'Record updated On Patient id 266', 266, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:11:00', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On Patient id 267', 267, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:12:41', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'Record updated On Patient id 267', 267, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:12:41', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On Patient id 268', 268, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:14:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'Record updated On Patient id 268', 268, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:14:37', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'New Record inserted On Patient id 269', 269, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:20:13', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'Record updated On Patient id 269', 269, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:20:13', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On Patient id 270', 270, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:21:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'Record updated On Patient id 270', 270, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 15:21:44', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'New Record inserted On Medicine Category id 1', 1, 1, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 19:43:57', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'New Record inserted On Medicine Category id 2', 2, 1, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 19:44:19', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'New Record inserted On Medicine Category id 3', 3, 1, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 19:44:32', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On Medicine Category id 4', 4, 1, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-10 19:44:40', '2023-02-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'New Record inserted On Unit id 1', 1, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:12:32', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'New Record inserted On Unit id 2', 2, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:16:20', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'New Record inserted On Unit id 3', 3, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:21:43', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'New Record inserted On Unit id 4', 4, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:22:06', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On Unit id 5', 5, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:22:43', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On Unit id 6', 6, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:23:21', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On Unit id 7', 7, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:23:47', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On Unit id 8', 8, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:24:43', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'New Record inserted On Unit id 9', 9, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:25:12', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'New Record inserted On Unit id 10', 10, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:25:44', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'New Record inserted On Unit id 11', 11, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:27:21', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'New Record inserted On Unit id 12', 12, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:27:50', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'New Record inserted On Unit id 13', 13, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:28:51', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On Unit id 14', 14, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:29:18', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On Unit id 15', 15, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:29:40', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'New Record inserted On Unit id 16', 16, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:30:21', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'New Record inserted On Unit id 17', 17, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:30:46', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'New Record inserted On Unit id 18', 18, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:31:10', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On Unit id 19', 19, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:31:38', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On Unit id 20', 20, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:31:56', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'New Record inserted On Unit id 21', 21, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:32:27', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'New Record inserted On Unit id 22', 22, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:32:52', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On Unit id 23', 23, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:33:10', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On Unit id 24', 24, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:38:45', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'New Record inserted On Pathology Parameter id 1', 1, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:48:35', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'New Record inserted On Pathology Parameter id 2', 2, 3, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-11 13:53:19', '2023-02-11');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'New Record inserted On Read System Notification id 4', 4, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:23', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On Read System Notification id 5', 5, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:28', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'New Record inserted On Read System Notification id 6', 6, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:31', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On Read System Notification id 7', 7, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:32', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'New Record inserted On Read System Notification id 8', 8, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:32', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'New Record inserted On Read System Notification id 9', 9, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:34', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'New Record inserted On Read System Notification id 10', 10, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:53:34', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'Record updated On Bed id 2', 2, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:54:24', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'Record updated On IPD id 3', 3, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:54:24', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'New Record inserted On Patient bed history id 4', 4, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:54:24', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'New Record inserted On Read System Notification id 11', 11, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:56:30', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'New Record inserted On Patient id 271', 271, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:58:33', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record updated On Patient id 271', 271, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 13:58:33', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'New Record inserted On Patient id 272', 272, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:01:43', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'Record updated On Patient id 272', 272, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:01:43', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'New Record inserted On Patient id 273', 273, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:03:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'Record updated On Patient id 273', 273, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:03:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'New Record inserted On Patient id 274', 274, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:05:10', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'Record updated On Patient id 274', 274, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:05:10', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'New Record inserted On Patient id 275', 275, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:07:13', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'Record updated On Patient id 275', 275, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:07:13', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'New Record inserted On Patient id 276', 276, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:09:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'Record updated On Patient id 276', 276, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:09:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'New Record inserted On Patient id 277', 277, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:10:46', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'Record updated On Patient id 277', 277, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:10:46', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'New Record inserted On Patient id 278', 278, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:11:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'Record updated On Patient id 278', 278, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:11:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'New Record inserted On Patient id 279', 279, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:12:55', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updated On Patient id 279', 279, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:12:55', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'New Record inserted On Patient id 280', 280, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:14:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record updated On Patient id 280', 280, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:14:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'New Record inserted On Patient id 281', 281, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:16:02', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'Record updated On Patient id 281', 281, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:16:02', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'New Record inserted On Patient id 282', 282, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:17:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'Record updated On Patient id 282', 282, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:17:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'New Record inserted On Patient id 283', 283, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:19:03', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'Record updated On Patient id 283', 283, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:19:03', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'New Record inserted On Patient id 284', 284, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:20:17', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'Record updated On Patient id 284', 284, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:20:17', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'New Record inserted On Patient id 285', 285, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:21:56', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'Record updated On Patient id 285', 285, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:21:56', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'New Record inserted On Patient id 286', 286, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:23:04', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'Record updated On Patient id 286', 286, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:23:04', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'New Record inserted On Patient id 287', 287, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:24:19', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'Record updated On Patient id 287', 287, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:24:19', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On Patient id 288', 288, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:25:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'Record updated On Patient id 288', 288, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:25:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'New Record inserted On Patient id 289', 289, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:29:40', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'Record updated On Patient id 289', 289, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:29:40', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'New Record inserted On Patient id 290', 290, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:30:51', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'Record updated On Patient id 290', 290, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:30:51', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'New Record inserted On Patient id 291', 291, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:31:57', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'Record updated On Patient id 291', 291, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:31:57', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'New Record inserted On Patient id 292', 292, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:35:24', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'Record updated On Patient id 292', 292, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:35:24', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On Patient id 293', 293, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:37:58', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'Record updated On Patient id 293', 293, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:37:58', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On Patient id 294', 294, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:38:50', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'Record updated On Patient id 294', 294, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:38:50', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On Patient id 295', 295, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:40:22', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'Record updated On Patient id 295', 295, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:40:22', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'New Record inserted On Patient id 296', 296, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:42:07', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'Record updated On Patient id 296', 296, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:42:07', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On Patient id 297', 297, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:43:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'Record updated On Patient id 297', 297, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 14:43:12', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On Patient id 298', 298, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:16:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'Record updated On Patient id 298', 298, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:16:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On Patient id 299', 299, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:18:01', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'Record updated On Patient id 299', 299, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:18:01', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On Patient id 300', 300, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:19:05', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'Record updated On Patient id 300', 300, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:19:05', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'New Record inserted On Patient id 301', 301, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:20:07', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'Record updated On Patient id 301', 301, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:20:07', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On Patient id 302', 302, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:21:03', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'Record updated On Patient id 302', 302, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:21:03', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On Patient id 303', 303, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:22:02', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'Record updated On Patient id 303', 303, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:22:02', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On Patient id 304', 304, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:23:00', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'Record updated On Patient id 304', 304, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:23:00', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'New Record inserted On Patient id 305', 305, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:24:18', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'Record updated On Patient id 305', 305, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:24:18', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'New Record inserted On Patient id 306', 306, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:25:21', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'Record updated On Patient id 306', 306, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:25:21', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On Patient id 307', 307, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:27:37', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'Record updated On Patient id 307', 307, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:27:37', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'New Record inserted On Patient id 308', 308, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:28:54', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'Record updated On Patient id 308', 308, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:28:54', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On Patient id 309', 309, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:31:23', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'Record updated On Patient id 309', 309, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:31:23', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On Patient id 310', 310, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:32:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'Record updated On Patient id 310', 310, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:32:59', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'New Record inserted On Patient id 311', 311, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:34:23', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'Record updated On Patient id 311', 311, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:34:23', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On Patient id 312', 312, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:38:09', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'Record updated On Patient id 312', 312, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:38:09', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On Patient id 313', 313, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:39:46', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'Record updated On Patient id 313', 313, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:39:46', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'New Record inserted On Patient id 314', 314, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:41:48', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'Record updated On Patient id 314', 314, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:41:48', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On Patient id 315', 315, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:43:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'Record updated On Patient id 315', 315, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:43:14', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'New Record inserted On Patient id 316', 316, 9, 'Insert', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:44:57', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'Record updated On Patient id 316', 316, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:44:57', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'Record updated On Patient id 311', 311, 9, 'Update', '105.112.225.135', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-12 15:45:49', '2023-02-12');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On Patient id 317', 317, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:05:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'Record updated On Patient id 317', 317, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:05:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'New Record inserted On Patient id 318', 318, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:06:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'Record updated On Patient id 318', 318, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:06:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On Patient id 319', 319, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:07:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'Record updated On Patient id 319', 319, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:07:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'New Record inserted On Patient id 320', 320, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:10:19', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'Record updated On Patient id 320', 320, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:10:19', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'New Record inserted On Patient id 321', 321, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:12:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'Record updated On Patient id 321', 321, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:12:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On Patient id 322', 322, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:13:15', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'Record updated On Patient id 322', 322, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:13:15', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On Patient id 323', 323, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:14:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'Record updated On Patient id 323', 323, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:14:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'New Record inserted On Patient id 324', 324, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:14:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'Record updated On Patient id 324', 324, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:14:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'New Record inserted On Patient id 325', 325, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:16:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'Record updated On Patient id 325', 325, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:16:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'New Record inserted On Patient id 326', 326, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:18:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'Record updated On Patient id 326', 326, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:18:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'New Record inserted On Patient id 327', 327, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:18:39', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'Record updated On Patient id 327', 327, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:18:39', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On Patient id 328', 328, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:19:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'Record updated On Patient id 328', 328, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:19:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'New Record inserted On Patient id 329', 329, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:22:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'Record updated On Patient id 329', 329, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:22:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'New Record inserted On Patient id 330', 330, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:23:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'Record updated On Patient id 330', 330, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:23:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On Patient id 331', 331, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:24:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'Record updated On Patient id 331', 331, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 09:24:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'New Record inserted On Patient id 332', 332, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:26:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'Record updated On Patient id 332', 332, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:26:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On Patient id 333', 333, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:29:22', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'Record updated On Patient id 333', 333, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:29:22', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On Patient id 334', 334, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:36:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'Record updated On Patient id 334', 334, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:36:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'New Record inserted On Patient id 335', 335, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:39:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'Record updated On Patient id 335', 335, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:39:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'New Record inserted On Patient id 336', 336, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:41:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'Record updated On Patient id 336', 336, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:41:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On Patient id 337', 337, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:43:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'Record updated On Patient id 337', 337, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:43:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On Patient id 338', 338, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:49:14', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'Record updated On Patient id 338', 338, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:49:14', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On Patient id 339', 339, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:51:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'Record updated On Patient id 339', 339, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:51:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'Record updated On Patient id 83', 83, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:53:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'Record updated On Patient id 58', 58, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:54:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'Record updated On Patient id 338', 338, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:55:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'Record updated On Patient id 54', 54, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:56:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'Record updated On Patient id 333', 333, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 09:59:02', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'Record updated On Patient id 330', 330, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:02:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'Record updated On Patient id 160', 160, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:03:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record updated On Patient id 324', 324, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:09:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'New Record inserted On Patient id 340', 340, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:10:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'Record updated On Patient id 340', 340, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:10:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'Record updated On Patient id 340', 340, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:11:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On Patient id 341', 341, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:28:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'Record updated On Patient id 341', 341, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:28:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'New Record inserted On Patient id 342', 342, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:28:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'Record updated On Patient id 342', 342, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:28:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'New Record inserted On Patient id 343', 343, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:30:38', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'Record updated On Patient id 343', 343, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:30:38', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On Patient id 344', 344, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:32:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'Record updated On Patient id 344', 344, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:32:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'New Record inserted On Patient id 345', 345, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:41:54', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'Record updated On Patient id 345', 345, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:41:54', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On Patient id 346', 346, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:44:13', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'Record updated On Patient id 346', 346, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:44:13', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On Patient id 347', 347, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:49:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'Record updated On Patient id 347', 347, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 10:49:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On Patient id 348', 348, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:52:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'Record updated On Patient id 348', 348, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 10:52:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'Record updated On Patient id 346', 346, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:01:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On Patient id 349', 349, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:03:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'Record updated On Patient id 349', 349, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:03:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'New Record inserted On Patient id 350', 350, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:10:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'Record updated On Patient id 350', 350, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:10:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On Patient id 351', 351, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:13:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'Record updated On Patient id 351', 351, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:13:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On Patient id 352', 352, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:14:50', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'Record updated On Patient id 352', 352, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:14:50', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On Patient id 353', 353, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:15:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'Record updated On Patient id 353', 353, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:15:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On Patient id 354', 354, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:16:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'Record updated On Patient id 354', 354, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:16:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'New Record inserted On Patient id 355', 355, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:17:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'Record updated On Patient id 355', 355, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:17:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'New Record inserted On Patient id 356', 356, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:18:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'Record updated On Patient id 356', 356, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:18:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'New Record inserted On Patient id 357', 357, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:19:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'Record updated On Patient id 357', 357, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:19:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'New Record inserted On Patient id 358', 358, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:20:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'Record updated On Patient id 358', 358, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:20:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'New Record inserted On Patient id 359', 359, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:21:15', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'Record updated On Patient id 359', 359, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:21:15', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'New Record inserted On Patient id 360', 360, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:21:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'Record updated On Patient id 360', 360, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:21:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On Patient id 361', 361, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:23:43', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'Record updated On Patient id 361', 361, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:23:43', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On Patient id 362', 362, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:28:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'Record updated On Patient id 362', 362, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:28:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On Patient id 363', 363, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:30:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'Record updated On Patient id 363', 363, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:30:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'New Record inserted On Patient id 364', 364, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:30:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'Record updated On Patient id 364', 364, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:30:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'New Record inserted On Patient id 365', 365, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:31:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'Record updated On Patient id 365', 365, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:31:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On Patient id 366', 366, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:31:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'Record updated On Patient id 366', 366, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:31:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On Patient id 367', 367, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:33:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'Record updated On Patient id 367', 367, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:33:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On Patient id 368', 368, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:34:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'Record updated On Patient id 368', 368, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:34:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'New Record inserted On Patient id 369', 369, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:35:39', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'Record updated On Patient id 369', 369, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:35:39', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On Patient id 370', 370, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:37:17', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'Record updated On Patient id 370', 370, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:37:17', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On Patient id 371', 371, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:38:43', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'Record updated On Patient id 371', 371, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:38:43', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On Patient id 372', 372, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:50:36', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'Record updated On Patient id 372', 372, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:50:36', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On Patient id 373', 373, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:53:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'Record updated On Patient id 373', 373, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:53:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'Record updated On Patient id 373', 373, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:55:37', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On Patient id 374', 374, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:57:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'Record updated On Patient id 374', 374, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:57:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On Patient id 375', 375, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:59:54', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'Record updated On Patient id 375', 375, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 11:59:54', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'New Record inserted On Patient id 376', 376, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:59:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'Record updated On Patient id 376', 376, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 11:59:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'New Record inserted On Patient id 377', 377, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:01:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'Record updated On Patient id 377', 377, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:01:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'New Record inserted On Patient id 378', 378, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:01:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'Record updated On Patient id 378', 378, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:01:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On Patient id 379', 379, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:02:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'Record updated On Patient id 379', 379, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:02:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'New Record inserted On Patient id 380', 380, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:03:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'Record updated On Patient id 380', 380, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:03:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'New Record inserted On Patient id 381', 381, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:04:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'Record updated On Patient id 381', 381, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:04:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'New Record inserted On Patient id 382', 382, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:05:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'Record updated On Patient id 382', 382, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:05:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'New Record inserted On Patient id 383', 383, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:07:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'Record updated On Patient id 383', 383, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:07:08', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'New Record inserted On Patient id 384', 384, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:08:01', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record updated On Patient id 384', 384, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:08:01', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'New Record inserted On Patient id 385', 385, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:08:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record updated On Patient id 385', 385, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:08:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'New Record inserted On Patient id 386', 386, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:09:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'Record updated On Patient id 386', 386, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:09:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'New Record inserted On Patient id 387', 387, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:10:04', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'Record updated On Patient id 387', 387, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:10:04', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'New Record inserted On Patient id 388', 388, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:11:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'Record updated On Patient id 388', 388, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:11:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'New Record inserted On Patient id 389', 389, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:11:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'Record updated On Patient id 389', 389, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:11:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'New Record inserted On Patient id 390', 390, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:13:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'Record updated On Patient id 390', 390, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:13:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'New Record inserted On Patient id 391', 391, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:13:33', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'Record updated On Patient id 391', 391, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:13:33', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'New Record inserted On Patient id 392', 392, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:14:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'Record updated On Patient id 392', 392, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:14:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'New Record inserted On Patient id 393', 393, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:17:02', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'Record updated On Patient id 393', 393, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:17:02', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'New Record inserted On Patient id 394', 394, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:19:17', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'Record updated On Patient id 394', 394, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:19:17', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'New Record inserted On Patient id 395', 395, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:22:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'Record updated On Patient id 395', 395, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:22:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On Patient id 396', 396, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:32:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'Record updated On Patient id 396', 396, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:32:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On Patient id 397', 397, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:34:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'Record updated On Patient id 397', 397, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:34:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'New Record inserted On Patient id 398', 398, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:37:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'Record updated On Patient id 398', 398, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 12:37:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'New Record inserted On Patient id 399', 399, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:45:57', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'Record updated On Patient id 399', 399, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:45:57', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'New Record inserted On Patient id 400', 400, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:54:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'Record updated On Patient id 400', 400, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:54:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On Patient id 401', 401, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:55:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'Record updated On Patient id 401', 401, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 12:55:16', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'New Record inserted On Patient id 402', 402, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:04:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'Record updated On Patient id 402', 402, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:04:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'New Record inserted On Patient id 403', 403, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:12:46', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'Record updated On Patient id 403', 403, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:12:46', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'New Record inserted On Patient id 404', 404, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:14:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'Record updated On Patient id 404', 404, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:14:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'New Record inserted On Patient id 405', 405, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:19:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'Record updated On Patient id 405', 405, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:19:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On Patient id 406', 406, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:21:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'Record updated On Patient id 406', 406, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:21:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On Patient id 407', 407, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:29:42', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'Record updated On Patient id 407', 407, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:29:42', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'New Record inserted On Patient id 408', 408, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:29:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'Record updated On Patient id 408', 408, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:29:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On Patient id 409', 409, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:30:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'Record updated On Patient id 409', 409, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:30:59', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'New Record inserted On Patient id 410', 410, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:33:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'Record updated On Patient id 410', 410, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:33:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On Patient id 411', 411, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:33:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'Record updated On Patient id 411', 411, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:33:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On Patient id 412', 412, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:33:57', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'Record updated On Patient id 412', 412, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:33:57', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On Patient id 413', 413, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:34:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'Record updated On Patient id 413', 413, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:34:34', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'New Record inserted On Patient id 414', 414, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:35:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'Record updated On Patient id 414', 414, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:35:23', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'New Record inserted On Patient id 415', 415, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:36:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'Record updated On Patient id 415', 415, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:36:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'New Record inserted On Patient id 416', 416, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:37:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'Record updated On Patient id 416', 416, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:37:05', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On Patient id 417', 417, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:38:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'Record updated On Patient id 417', 417, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:38:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'New Record inserted On Patient id 418', 418, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:40:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'Record updated On Patient id 418', 418, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:40:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'New Record inserted On Patient id 419', 419, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:41:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'Record updated On Patient id 419', 419, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:41:12', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'Record updated On Patient id 400', 400, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:41:47', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'New Record inserted On Patient id 420', 420, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:42:06', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'Record updated On Patient id 420', 420, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:42:06', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'Record updated On Patient id 419', 419, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:43:26', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'New Record inserted On Patient id 421', 421, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:43:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'Record updated On Patient id 421', 421, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:43:28', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On Patient id 422', 422, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:44:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'Record updated On Patient id 422', 422, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:44:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On Patient id 423', 423, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:46:13', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'Record updated On Patient id 423', 423, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:46:13', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'New Record inserted On Patient id 424', 424, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:47:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'Record updated On Patient id 424', 424, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:47:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On Patient id 425', 425, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:47:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'Record updated On Patient id 425', 425, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:47:21', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'New Record inserted On Patient id 426', 426, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:48:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'Record updated On Patient id 426', 426, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:48:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'New Record inserted On Patient id 427', 427, 2, 'Insert', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:49:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'Record updated On Patient id 427', 427, 2, 'Update', '105.112.233.244', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:49:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'New Record inserted On Patient id 428', 428, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:50:33', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'Record updated On Patient id 428', 428, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:50:33', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'New Record inserted On Patient id 429', 429, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:51:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'Record updated On Patient id 429', 429, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:51:29', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'New Record inserted On Patient id 430', 430, 9, 'Insert', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:53:26', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'Record updated On Patient id 430', 430, 9, 'Update', '105.112.233.244', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:53:26', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'Record updated On Patient id 427', 427, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:57:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'New Record inserted On Patient id 431', 431, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:58:25', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'Record updated On Patient id 431', 431, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 13:58:25', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'New Record inserted On Patient id 432', 432, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:59:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'Record updated On Patient id 432', 432, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 13:59:45', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'New Record inserted On Patient id 433', 433, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:02:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'Record updated On Patient id 433', 433, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:02:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On Patient id 434', 434, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:04:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'Record updated On Patient id 434', 434, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:04:10', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'New Record inserted On Patient id 435', 435, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:06:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'Record updated On Patient id 435', 435, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:06:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'New Record inserted On Patient id 436', 436, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:07:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'Record updated On Patient id 436', 436, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:07:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On Patient id 437', 437, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:10:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'Record updated On Patient id 437', 437, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 14:10:32', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On Patient id 438', 438, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:18:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'Record updated On Patient id 438', 438, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:18:20', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On Patient id 439', 439, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:19:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'Record updated On Patient id 439', 439, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:19:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'New Record inserted On Patient id 440', 440, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:22:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'Record updated On Patient id 440', 440, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:22:49', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'New Record inserted On Patient id 441', 441, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:24:36', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'Record updated On Patient id 441', 441, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:24:36', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'New Record inserted On Patient id 442', 442, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:25:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'Record updated On Patient id 442', 442, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:25:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'New Record inserted On Patient id 443', 443, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:27:19', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'Record updated On Patient id 443', 443, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:27:19', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'New Record inserted On Patient id 444', 444, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:28:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'Record updated On Patient id 444', 444, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:28:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'New Record inserted On Patient id 445', 445, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:29:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'Record updated On Patient id 445', 445, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:29:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'New Record inserted On Patient id 446', 446, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:30:41', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'Record updated On Patient id 446', 446, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:30:41', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'New Record inserted On Patient id 447', 447, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:36:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'Record updated On Patient id 447', 447, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:36:58', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'New Record inserted On Patient id 448', 448, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:38:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'Record updated On Patient id 448', 448, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:38:44', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'New Record inserted On Patient id 449', 449, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:40:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'Record updated On Patient id 449', 449, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:40:51', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On Patient id 450', 450, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:43:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'Record updated On Patient id 450', 450, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:43:18', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'New Record inserted On Patient id 451', 451, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:44:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'Record updated On Patient id 451', 451, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:44:55', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'New Record inserted On Patient id 452', 452, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:46:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'Record updated On Patient id 452', 452, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:46:27', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On Patient id 453', 453, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:47:50', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'Record updated On Patient id 453', 453, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:47:50', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On Patient id 454', 454, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:49:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'Record updated On Patient id 454', 454, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:49:00', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On Patient id 455', 455, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:50:38', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'Record updated On Patient id 455', 455, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:50:38', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'New Record inserted On Patient id 456', 456, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:52:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'Record updated On Patient id 456', 456, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:52:31', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On Patient id 457', 457, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:53:52', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'Record updated On Patient id 457', 457, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:53:52', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On Patient id 458', 458, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:55:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'Record updated On Patient id 458', 458, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:55:40', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'New Record inserted On Patient id 459', 459, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:56:25', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'Record updated On Patient id 459', 459, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:56:25', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On Patient id 460', 460, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:57:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'Record updated On Patient id 460', 460, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:57:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'New Record inserted On Patient id 461', 461, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:59:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'Record updated On Patient id 461', 461, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 14:59:03', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On Patient id 462', 462, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 15:00:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'Record updated On Patient id 462', 462, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-13 15:00:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On Patient id 463', 463, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:02:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'Record updated On Patient id 463', 463, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:02:56', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'New Record inserted On Patient id 464', 464, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:06:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'Record updated On Patient id 464', 464, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:06:24', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'Record updated On Patient id 464', 464, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:11:57', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'New Record inserted On Patient id 465', 465, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:15:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'Record updated On Patient id 465', 465, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:15:48', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'New Record inserted On Patient id 466', 466, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:36:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'Record updated On Patient id 466', 466, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:36:07', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On Patient id 467', 467, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:51:52', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'Record updated On Patient id 467', 467, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:51:52', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'New Record inserted On Patient id 468', 468, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:53:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'Record updated On Patient id 468', 468, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 15:53:09', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'New Record inserted On Patient id 469', 469, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 16:06:14', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'Record updated On Patient id 469', 469, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 16:06:14', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'New Record inserted On Patient id 470', 470, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 16:08:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'Record updated On Patient id 470', 470, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-13 16:08:35', '2023-02-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'New Record inserted On Patient id 471', 471, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:00:06', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'Record updated On Patient id 471', 471, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:00:06', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'New Record inserted On Patient id 472', 472, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:01:58', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'Record updated On Patient id 472', 472, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:01:58', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'New Record inserted On Patient id 473', 473, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:03:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'Record updated On Patient id 473', 473, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:03:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'New Record inserted On Patient id 474', 474, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:06:29', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'Record updated On Patient id 474', 474, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:06:29', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'New Record inserted On Patient id 475', 475, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:08:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'Record updated On Patient id 475', 475, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:08:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'New Record inserted On Patient id 476', 476, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:10:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'Record updated On Patient id 476', 476, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:10:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'New Record inserted On Patient id 477', 477, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:11:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'Record updated On Patient id 477', 477, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:11:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'New Record inserted On Patient id 478', 478, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:20:25', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'Record updated On Patient id 478', 478, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:20:25', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'New Record inserted On Patient id 479', 479, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:25:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'Record updated On Patient id 479', 479, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:25:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'New Record inserted On Patient id 480', 480, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:27:14', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'Record updated On Patient id 480', 480, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:27:14', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'New Record inserted On Patient id 481', 481, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:30:27', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'Record updated On Patient id 481', 481, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:30:27', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On Patient id 482', 482, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:31:50', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'Record updated On Patient id 482', 482, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:31:50', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'New Record inserted On Patient id 483', 483, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:40:26', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'Record updated On Patient id 483', 483, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:40:26', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'New Record inserted On Patient id 484', 484, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:49:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'Record updated On Patient id 484', 484, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:49:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'Record updated On Patient id 484', 484, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:52:22', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'New Record inserted On Patient id 485', 485, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:55:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'Record updated On Patient id 485', 485, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:55:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'New Record inserted On Patient id 486', 486, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:59:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'Record updated On Patient id 486', 486, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 09:59:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'Record updated On Patient id 486', 486, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:00:35', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'New Record inserted On Patient id 487', 487, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:05:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'Record updated On Patient id 487', 487, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:05:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'New Record inserted On Patient id 488', 488, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:06:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'Record updated On Patient id 488', 488, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:06:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'New Record inserted On Patient id 489', 489, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:06:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'Record updated On Patient id 489', 489, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:06:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'New Record inserted On Patient id 490', 490, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:07:58', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'Record updated On Patient id 490', 490, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:07:58', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'New Record inserted On Patient id 491', 491, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:09:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'Record updated On Patient id 491', 491, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:09:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'New Record inserted On Patient id 492', 492, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:11:08', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'Record updated On Patient id 492', 492, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:11:08', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'New Record inserted On Patient id 493', 493, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:11:36', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'Record updated On Patient id 493', 493, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:11:36', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On Patient id 494', 494, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:12:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'Record updated On Patient id 494', 494, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:12:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'New Record inserted On Patient id 495', 495, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:13:28', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'Record updated On Patient id 495', 495, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:13:28', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'New Record inserted On Patient id 496', 496, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:14:38', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'Record updated On Patient id 496', 496, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:14:38', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'New Record inserted On Patient id 497', 497, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:15:55', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'Record updated On Patient id 497', 497, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:15:55', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'New Record inserted On Patient id 498', 498, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:17:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'Record updated On Patient id 498', 498, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:17:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'New Record inserted On Patient id 499', 499, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:18:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'Record updated On Patient id 499', 499, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:18:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'New Record inserted On Patient id 500', 500, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:19:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'Record updated On Patient id 500', 500, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:19:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'New Record inserted On Patient id 501', 501, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:20:09', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'Record updated On Patient id 501', 501, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:20:09', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'New Record inserted On Patient id 502', 502, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:21:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'Record updated On Patient id 502', 502, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:21:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'New Record inserted On Patient id 503', 503, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:21:54', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'Record updated On Patient id 503', 503, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:21:54', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'New Record inserted On Patient id 504', 504, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:22:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'Record updated On Patient id 504', 504, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:22:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'New Record inserted On Patient id 505', 505, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:24:36', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'Record updated On Patient id 505', 505, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:24:36', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'New Record inserted On Patient id 506', 506, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:24:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'Record updated On Patient id 506', 506, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:24:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'New Record inserted On Patient id 507', 507, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:26:44', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'Record updated On Patient id 507', 507, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:26:44', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'New Record inserted On Patient id 508', 508, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:27:45', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'Record updated On Patient id 508', 508, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:27:45', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'New Record inserted On Patient id 509', 509, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:28:35', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'Record updated On Patient id 509', 509, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:28:35', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'New Record inserted On Patient id 510', 510, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:30:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1224, 'Record updated On Patient id 510', 510, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:30:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1225, 'New Record inserted On Patient id 511', 511, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:31:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1226, 'Record updated On Patient id 511', 511, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:31:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1227, 'New Record inserted On Patient id 512', 512, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:31:25', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1228, 'Record updated On Patient id 512', 512, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:31:25', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1229, 'New Record inserted On Patient id 513', 513, 2, 'Insert', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:31:34', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1230, 'Record updated On Patient id 513', 513, 2, 'Update', '105.112.123.81', 'Windows 10', 'Firefox 109.0', '2023-02-14 10:31:34', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1231, 'New Record inserted On Patient id 514', 514, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:34:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1232, 'Record updated On Patient id 514', 514, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:34:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1233, 'Record updated On Bed id 1', 1, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:36:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1234, 'Record updated On IPD id 1', 1, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:36:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1235, 'New Record inserted On Patient bed history id 5', 5, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:36:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1236, 'New Record inserted On Patient id 515', 515, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:38:46', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1237, 'Record updated On Patient id 515', 515, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:38:46', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1238, 'New Record inserted On Patient id 516', 516, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:40:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1239, 'Record updated On Patient id 516', 516, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:40:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1240, 'New Record inserted On Patient id 517', 517, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:41:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1241, 'Record updated On Patient id 517', 517, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:41:23', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1242, 'New Record inserted On Patient id 518', 518, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:42:43', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1243, 'Record updated On Patient id 518', 518, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:42:43', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1244, 'New Record inserted On Patient id 519', 519, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:44:22', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1245, 'Record updated On Patient id 519', 519, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:44:22', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1246, 'New Record inserted On Patient id 520', 520, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:46:52', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1247, 'Record updated On Patient id 520', 520, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:46:52', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1248, 'New Record inserted On Patient id 521', 521, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:48:08', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1249, 'Record updated On Patient id 521', 521, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:48:08', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1250, 'New Record inserted On Patient id 522', 522, 9, 'Insert', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:49:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1251, 'Record updated On Patient id 522', 522, 9, 'Update', '105.112.123.81', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 10:49:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1252, 'New Record inserted On Patient id 523', 523, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:50:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1253, 'Record updated On Patient id 523', 523, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:50:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1254, 'New Record inserted On Patient id 524', 524, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:52:01', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1255, 'Record updated On Patient id 524', 524, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:52:01', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1256, 'New Record inserted On Patient id 525', 525, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:54:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1257, 'Record updated On Patient id 525', 525, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:54:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1258, 'New Record inserted On Patient id 526', 526, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:56:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1259, 'Record updated On Patient id 526', 526, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:56:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1260, 'New Record inserted On Patient id 527', 527, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:57:29', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1261, 'Record updated On Patient id 527', 527, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 11:57:29', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1262, 'Record updated On Patient id 513', 513, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 12:01:09', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1263, 'New Record inserted On Patient id 528', 528, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:15:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1264, 'Record updated On Patient id 528', 528, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:15:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1265, 'New Record inserted On Patient id 529', 529, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:18:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1266, 'Record updated On Patient id 529', 529, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:18:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1267, 'New Record inserted On Patient id 530', 530, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:19:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1268, 'Record updated On Patient id 530', 530, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:19:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1269, 'New Record inserted On Patient id 531', 531, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:20:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1270, 'Record updated On Patient id 531', 531, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:20:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1271, 'New Record inserted On Patient id 532', 532, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:20:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1272, 'Record updated On Patient id 532', 532, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:20:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1273, 'New Record inserted On Patient id 533', 533, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:23:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1274, 'Record updated On Patient id 533', 533, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:23:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1275, 'New Record inserted On Patient id 534', 534, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:24:09', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1276, 'Record updated On Patient id 534', 534, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:24:09', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1277, 'New Record inserted On Patient id 535', 535, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:26:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1278, 'Record updated On Patient id 535', 535, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:26:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1279, 'New Record inserted On Patient id 536', 536, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:27:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1280, 'Record updated On Patient id 536', 536, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:27:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1281, 'New Record inserted On Patient id 537', 537, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:32:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1282, 'Record updated On Patient id 537', 537, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:32:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1283, 'New Record inserted On Patient id 538', 538, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:34:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1284, 'Record updated On Patient id 538', 538, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 13:34:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1285, 'New Record inserted On Patient id 539', 539, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:56:50', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1286, 'Record updated On Patient id 539', 539, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:56:50', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1287, 'New Record inserted On Patient id 540', 540, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:59:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1288, 'Record updated On Patient id 540', 540, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 13:59:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1289, 'New Record inserted On Patient id 541', 541, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 14:02:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1290, 'Record updated On Patient id 541', 541, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 14:02:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1291, 'New Record inserted On Patient id 542', 542, 2, 'Insert', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 14:16:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1292, 'Record updated On Patient id 542', 542, 2, 'Update', '105.112.230.185', 'Windows 10', 'Firefox 109.0', '2023-02-14 14:16:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1293, 'New Record inserted On Patient id 543', 543, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 14:36:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1294, 'Record updated On Patient id 543', 543, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 14:36:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1295, 'New Record inserted On Patient id 544', 544, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:19:30', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1296, 'Record updated On Patient id 544', 544, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:19:30', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1297, 'New Record inserted On Patient id 545', 545, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:21:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1298, 'Record updated On Patient id 545', 545, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:21:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1299, 'New Record inserted On Patient id 546', 546, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:22:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1300, 'Record updated On Patient id 546', 546, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:22:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1301, 'New Record inserted On Patient id 547', 547, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:23:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1302, 'Record updated On Patient id 547', 547, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:23:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1303, 'New Record inserted On Patient id 548', 548, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:24:33', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1304, 'Record updated On Patient id 548', 548, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:24:33', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1305, 'New Record inserted On Patient id 549', 549, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:26:36', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1306, 'Record updated On Patient id 549', 549, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:26:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1307, 'New Record inserted On Patient id 550', 550, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:27:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1308, 'Record updated On Patient id 550', 550, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:27:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1309, 'New Record inserted On Patient id 551', 551, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:32:31', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1310, 'Record updated On Patient id 551', 551, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:32:31', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1311, 'New Record inserted On Patient id 552', 552, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:34:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1312, 'Record updated On Patient id 552', 552, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:34:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1313, 'New Record inserted On Patient id 553', 553, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:35:19', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1314, 'Record updated On Patient id 553', 553, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:35:19', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1315, 'New Record inserted On Patient id 554', 554, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:37:06', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1316, 'Record updated On Patient id 554', 554, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:37:06', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1317, 'New Record inserted On Patient id 555', 555, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:40:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1318, 'Record updated On Patient id 555', 555, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:40:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1319, 'New Record inserted On Patient id 556', 556, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:41:07', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1320, 'Record updated On Patient id 556', 556, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:41:07', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1321, 'New Record inserted On Patient id 557', 557, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:42:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1322, 'Record updated On Patient id 557', 557, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:42:24', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1323, 'New Record inserted On Patient id 558', 558, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:43:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1324, 'Record updated On Patient id 558', 558, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:43:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1325, 'New Record inserted On Patient id 559', 559, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:56:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1326, 'Record updated On Patient id 559', 559, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:56:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1327, 'New Record inserted On Patient id 560', 560, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:58:28', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1328, 'Record updated On Patient id 560', 560, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 15:58:28', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1329, 'New Record inserted On Patient id 561', 561, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:00:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1330, 'Record updated On Patient id 561', 561, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:00:04', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1331, 'New Record inserted On Patient id 562', 562, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:01:15', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1332, 'Record updated On Patient id 562', 562, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:01:15', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1333, 'New Record inserted On Patient id 563', 563, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:02:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1334, 'Record updated On Patient id 563', 563, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:02:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1335, 'New Record inserted On Patient id 564', 564, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:03:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1336, 'Record updated On Patient id 564', 564, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:03:03', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1337, 'New Record inserted On Patient id 565', 565, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:03:48', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1338, 'Record updated On Patient id 565', 565, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:03:48', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1339, 'New Record inserted On Patient id 566', 566, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:06:56', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1340, 'Record updated On Patient id 566', 566, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:06:56', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1341, 'New Record inserted On Patient id 567', 567, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:08:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1342, 'Record updated On Patient id 567', 567, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:08:05', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1343, 'New Record inserted On Patient id 568', 568, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:09:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1344, 'Record updated On Patient id 568', 568, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:09:57', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1345, 'New Record inserted On Patient id 569', 569, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:12:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1346, 'Record updated On Patient id 569', 569, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:12:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1347, 'New Record inserted On Patient id 570', 570, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:13:15', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1348, 'Record updated On Patient id 570', 570, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:13:15', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1349, 'New Record inserted On Patient id 571', 571, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:14:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1350, 'Record updated On Patient id 571', 571, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:14:39', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1351, 'New Record inserted On Patient id 572', 572, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:16:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1352, 'Record updated On Patient id 572', 572, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:16:00', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1353, 'New Record inserted On Patient id 573', 573, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:18:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1354, 'Record updated On Patient id 573', 573, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:18:13', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1355, 'New Record inserted On Patient id 574', 574, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:19:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1356, 'Record updated On Patient id 574', 574, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:19:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1357, 'New Record inserted On Patient id 575', 575, 9, 'Insert', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:20:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1358, 'Record updated On Patient id 575', 575, 9, 'Update', '105.112.230.185', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:20:59', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1359, 'New Record inserted On Patient id 576', 576, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:53:16', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1360, 'Record updated On Patient id 576', 576, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:53:16', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1361, 'Record updated On Patient id 576', 576, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:54:50', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1362, 'New Record inserted On Patient id 577', 577, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:56:35', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1363, 'Record updated On Patient id 577', 577, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:56:35', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1364, 'New Record inserted On Patient id 578', 578, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:58:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1365, 'Record updated On Patient id 578', 578, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:58:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1366, 'New Record inserted On Patient id 579', 579, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:59:42', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1367, 'Record updated On Patient id 579', 579, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 16:59:42', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1368, 'New Record inserted On Patient id 580', 580, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:01:46', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1369, 'Record updated On Patient id 580', 580, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:01:46', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1370, 'New Record inserted On Patient id 581', 581, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:04:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1371, 'Record updated On Patient id 581', 581, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:04:17', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1372, 'New Record inserted On Patient id 582', 582, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:06:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1373, 'Record updated On Patient id 582', 582, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:06:18', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1374, 'New Record inserted On Patient id 583', 583, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:07:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1375, 'Record updated On Patient id 583', 583, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:07:49', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1376, 'New Record inserted On Patient id 584', 584, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:12:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1377, 'Record updated On Patient id 584', 584, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:12:02', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1378, 'New Record inserted On Patient id 585', 585, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:13:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1379, 'Record updated On Patient id 585', 585, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:13:37', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1380, 'New Record inserted On Patient id 586', 586, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:15:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1381, 'Record updated On Patient id 586', 586, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:15:41', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1382, 'New Record inserted On Patient id 587', 587, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:17:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1383, 'Record updated On Patient id 587', 587, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:17:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1384, 'New Record inserted On Patient id 588', 588, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:19:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1385, 'Record updated On Patient id 588', 588, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:19:51', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1386, 'New Record inserted On Patient id 589', 589, 9, 'Insert', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:21:16', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1387, 'Record updated On Patient id 589', 589, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:21:16', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1388, 'Record updated On Patient id 211', 211, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:28:08', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1389, 'Record updated On Patient id 311', 311, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:29:53', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1390, 'Record updated On Patient id 511', 511, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:32:21', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1391, 'Record updated On Patient id 512', 512, 9, 'Update', '105.112.121.225', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-14 17:34:25', '2023-02-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1392, 'New Record inserted On Chat Messages id 9', 9, 7, 'Insert', '105.112.229.15', 'Windows 10', 'Firefox 109.0', '2023-02-15 12:01:17', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1393, 'Record updated On Patient id 536', 536, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:23:53', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1394, 'New Record inserted On Patient id 590', 590, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:47:24', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1395, 'Record updated On Patient id 590', 590, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:47:24', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1396, 'Record updated On Patient id 131', 131, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:48:05', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1397, 'Record updated On Patient id 132', 132, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:48:41', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1398, 'New Record inserted On Patient id 591', 591, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:51:06', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1399, 'Record updated On Patient id 591', 591, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 13:51:06', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1400, 'New Record inserted On Patient id 592', 592, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:37:42', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1401, 'Record updated On Patient id 592', 592, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:37:42', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1402, 'New Record inserted On Patient id 593', 593, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:40:14', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1403, 'Record updated On Patient id 593', 593, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:40:14', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1404, 'New Record inserted On Patient id 594', 594, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:41:33', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1405, 'Record updated On Patient id 594', 594, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:41:33', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1406, 'New Record inserted On Patient id 595', 595, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:42:36', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1407, 'Record updated On Patient id 595', 595, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:42:36', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1408, 'New Record inserted On Patient id 596', 596, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:43:58', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1409, 'Record updated On Patient id 596', 596, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:43:58', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1410, 'New Record inserted On Patient id 597', 597, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:47:34', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1411, 'Record updated On Patient id 597', 597, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:47:34', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1412, 'New Record inserted On Patient id 598', 598, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:49:09', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1413, 'Record updated On Patient id 598', 598, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:49:09', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1414, 'New Record inserted On Patient id 599', 599, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:51:06', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1415, 'Record updated On Patient id 599', 599, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:51:06', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1416, 'Record updated On Patient id 598', 598, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:51:47', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1417, 'New Record inserted On Patient id 600', 600, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:53:54', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1418, 'Record updated On Patient id 600', 600, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:53:54', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1419, 'New Record inserted On Patient id 601', 601, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:55:37', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1420, 'Record updated On Patient id 601', 601, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:55:37', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1421, 'New Record inserted On Patient id 602', 602, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:57:28', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1422, 'Record updated On Patient id 602', 602, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:57:28', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1423, 'New Record inserted On Patient id 603', 603, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:59:30', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1424, 'Record updated On Patient id 603', 603, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 14:59:30', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1425, 'New Record inserted On Patient id 604', 604, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:00:33', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1426, 'Record updated On Patient id 604', 604, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:00:33', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1427, 'New Record inserted On Patient id 605', 605, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:01:34', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1428, 'Record updated On Patient id 605', 605, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:01:34', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1429, 'New Record inserted On Patient id 606', 606, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:04:56', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1430, 'Record updated On Patient id 606', 606, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:04:56', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1431, 'New Record inserted On Patient id 607', 607, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:06:49', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1432, 'Record updated On Patient id 607', 607, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:06:49', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1433, 'New Record inserted On Patient id 608', 608, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:08:42', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1434, 'Record updated On Patient id 608', 608, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:08:42', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1435, 'New Record inserted On Patient id 609', 609, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:09:54', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1436, 'Record updated On Patient id 609', 609, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:09:54', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1437, 'New Record inserted On Patient id 610', 610, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:55:15', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1438, 'Record updated On Patient id 610', 610, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:55:15', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1439, 'New Record inserted On Patient id 611', 611, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:56:30', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1440, 'Record updated On Patient id 611', 611, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:56:30', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1441, 'New Record inserted On Patient id 612', 612, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:58:08', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1442, 'Record updated On Patient id 612', 612, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 15:58:08', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1443, 'New Record inserted On Patient id 613', 613, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:25:46', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1444, 'Record updated On Patient id 613', 613, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:25:46', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1445, 'New Record inserted On Patient id 614', 614, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:30:09', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1446, 'Record updated On Patient id 614', 614, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:30:09', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1447, 'New Record inserted On Patient id 615', 615, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:31:43', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1448, 'Record updated On Patient id 615', 615, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:31:43', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1449, 'New Record inserted On Patient id 616', 616, 9, 'Insert', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:32:41', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1450, 'Record updated On Patient id 616', 616, 9, 'Update', '105.112.229.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-15 16:32:41', '2023-02-15');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1451, 'New Record inserted On Patient id 617', 617, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:00:21', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1452, 'Record updated On Patient id 617', 617, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:00:21', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1453, 'Record updated On Patient id 337', 337, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:00:33', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1454, 'New Record inserted On Patient id 618', 618, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:02:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1455, 'Record updated On Patient id 618', 618, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:02:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1456, 'Record updated On Patient id 618', 618, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:05:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1457, 'New Record inserted On Patient id 619', 619, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:07:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1458, 'Record updated On Patient id 619', 619, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:07:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1459, 'New Record inserted On Patient id 620', 620, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:09:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1460, 'Record updated On Patient id 620', 620, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:09:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1461, 'New Record inserted On Patient id 621', 621, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:12:37', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1462, 'Record updated On Patient id 621', 621, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:12:37', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1463, 'Record updated On Patient id 488', 488, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:13:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1464, 'New Record inserted On Patient id 622', 622, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:14:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1465, 'Record updated On Patient id 622', 622, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:14:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1466, 'New Record inserted On Patient id 623', 623, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:16:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1467, 'Record updated On Patient id 623', 623, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:16:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1468, 'New Record inserted On Patient id 624', 624, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:17:58', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1469, 'Record updated On Patient id 624', 624, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:17:58', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1470, 'New Record inserted On Patient id 625', 625, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:20:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1471, 'Record updated On Patient id 625', 625, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:20:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1472, 'New Record inserted On Patient id 626', 626, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:25:04', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1473, 'Record updated On Patient id 626', 626, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:25:04', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1474, 'New Record inserted On Patient id 627', 627, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:27:39', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1475, 'Record updated On Patient id 627', 627, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:27:39', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1476, 'New Record inserted On Patient id 628', 628, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:29:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1477, 'Record updated On Patient id 628', 628, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:29:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1478, 'New Record inserted On Patient id 629', 629, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:40:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1479, 'Record updated On Patient id 629', 629, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:40:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1480, 'Record updated On Patient id 629', 629, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:42:47', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1481, 'New Record inserted On Patient id 630', 630, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:44:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1482, 'Record updated On Patient id 630', 630, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:44:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1483, 'New Record inserted On Patient id 631', 631, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:44:46', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1484, 'Record updated On Patient id 631', 631, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:44:46', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1485, 'New Record inserted On Patient id 632', 632, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:45:42', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1486, 'Record updated On Patient id 632', 632, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:45:42', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1487, 'New Record inserted On Patient id 633', 633, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:47:29', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1488, 'Record updated On Patient id 633', 633, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:47:29', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1489, 'New Record inserted On Patient id 634', 634, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:49:06', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1490, 'Record updated On Patient id 634', 634, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:49:06', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1491, 'New Record inserted On Patient id 635', 635, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:49:38', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1492, 'Record updated On Patient id 635', 635, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:49:38', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1493, 'New Record inserted On Patient id 636', 636, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:52:13', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1494, 'Record updated On Patient id 636', 636, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:52:13', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1495, 'New Record inserted On Patient id 637', 637, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:52:30', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1496, 'Record updated On Patient id 637', 637, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:52:30', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1497, 'New Record inserted On Patient id 638', 638, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:53:41', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1498, 'Record updated On Patient id 638', 638, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:53:41', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1499, 'New Record inserted On Patient id 639', 639, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:55:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1500, 'Record updated On Patient id 639', 639, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:55:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1501, 'New Record inserted On Patient id 640', 640, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:57:33', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1502, 'Record updated On Patient id 640', 640, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:57:33', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1503, 'Record updated On Patient id 639', 639, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 09:58:33', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1504, 'New Record inserted On Patient id 641', 641, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:59:48', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1505, 'Record updated On Patient id 641', 641, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 09:59:48', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1506, 'New Record inserted On Patient id 642', 642, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:00:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1507, 'Record updated On Patient id 642', 642, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:00:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1508, 'New Record inserted On Patient id 643', 643, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:01:20', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1509, 'Record updated On Patient id 643', 643, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:01:20', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1510, 'New Record inserted On Patient id 644', 644, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:01:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1511, 'Record updated On Patient id 644', 644, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:01:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1512, 'New Record inserted On Patient id 645', 645, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:02:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1513, 'Record updated On Patient id 645', 645, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:02:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1514, 'New Record inserted On Patient id 646', 646, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:02:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1515, 'Record updated On Patient id 646', 646, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:02:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1516, 'New Record inserted On Patient id 647', 647, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:04:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1517, 'Record updated On Patient id 647', 647, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:04:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1518, 'New Record inserted On Patient id 648', 648, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:04:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1519, 'Record updated On Patient id 648', 648, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:04:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1520, 'New Record inserted On Patient id 649', 649, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:06:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1521, 'Record updated On Patient id 649', 649, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:06:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1522, 'New Record inserted On Patient id 650', 650, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:07:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1523, 'Record updated On Patient id 650', 650, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:07:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1524, 'New Record inserted On Patient id 651', 651, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:10:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1525, 'Record updated On Patient id 651', 651, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:10:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1526, 'New Record inserted On Patient id 652', 652, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:10:32', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1527, 'Record updated On Patient id 652', 652, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:10:32', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1528, 'New Record inserted On Patient id 653', 653, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:16:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1529, 'Record updated On Patient id 653', 653, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:16:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1530, 'New Record inserted On Patient id 654', 654, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:17:47', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1531, 'Record updated On Patient id 654', 654, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:17:47', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1532, 'New Record inserted On Patient id 655', 655, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:20:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1533, 'Record updated On Patient id 655', 655, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:20:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1534, 'New Record inserted On Patient id 656', 656, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:22:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1535, 'Record updated On Patient id 656', 656, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:22:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1536, 'New Record inserted On Patient id 657', 657, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:34:14', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1537, 'Record updated On Patient id 657', 657, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:34:14', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1538, 'New Record inserted On Patient id 658', 658, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:39:39', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1539, 'Record updated On Patient id 658', 658, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:39:39', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1540, 'New Record inserted On Patient id 659', 659, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:48:13', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1541, 'Record updated On Patient id 659', 659, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 10:48:13', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1542, 'New Record inserted On Patient id 660', 660, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:49:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1543, 'Record updated On Patient id 660', 660, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:49:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1544, 'New Record inserted On Patient id 661', 661, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:59:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1545, 'Record updated On Patient id 661', 661, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 10:59:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1546, 'New Record inserted On Patient id 662', 662, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:01:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1547, 'Record updated On Patient id 662', 662, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:01:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1548, 'New Record inserted On Patient id 663', 663, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:09:58', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1549, 'Record updated On Patient id 663', 663, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:09:58', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1550, 'New Record inserted On Patient id 664', 664, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:10:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1551, 'Record updated On Patient id 664', 664, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:10:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1552, 'New Record inserted On Patient id 665', 665, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:14:56', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1553, 'Record updated On Patient id 665', 665, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:14:56', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1554, 'New Record inserted On Patient id 666', 666, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:17:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1555, 'Record updated On Patient id 666', 666, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:17:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1556, 'New Record inserted On Patient id 667', 667, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:23:52', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1557, 'Record updated On Patient id 667', 667, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:23:52', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1558, 'New Record inserted On Patient id 668', 668, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:33:53', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1559, 'Record updated On Patient id 668', 668, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:33:53', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1560, 'New Record inserted On Patient id 669', 669, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:35:06', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1561, 'Record updated On Patient id 669', 669, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:35:06', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1562, 'New Record inserted On Patient id 670', 670, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:36:29', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1563, 'Record updated On Patient id 670', 670, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:36:29', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1564, 'New Record inserted On Patient id 671', 671, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:38:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1565, 'Record updated On Patient id 671', 671, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 11:38:18', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1566, 'New Record inserted On Patient id 672', 672, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:01:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1567, 'Record updated On Patient id 672', 672, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:01:05', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1568, 'New Record inserted On Patient id 673', 673, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:03:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1569, 'Record updated On Patient id 673', 673, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:03:57', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1570, 'New Record inserted On Patient id 674', 674, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:05:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1571, 'Record updated On Patient id 674', 674, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:05:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1572, 'New Record inserted On Patient id 675', 675, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:16:31', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1573, 'Record updated On Patient id 675', 675, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:16:31', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1574, 'New Record inserted On Patient id 676', 676, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:21:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1575, 'Record updated On Patient id 676', 676, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:21:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1576, 'New Record inserted On Patient id 677', 677, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:24:46', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1577, 'Record updated On Patient id 677', 677, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:24:46', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1578, 'New Record inserted On Patient id 678', 678, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:26:41', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1579, 'Record updated On Patient id 678', 678, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:26:41', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1580, 'New Record inserted On Patient id 679', 679, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:29:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1581, 'Record updated On Patient id 679', 679, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:29:08', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1582, 'Record updated On Patient id 679', 679, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:29:45', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1583, 'New Record inserted On Patient id 680', 680, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:33:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1584, 'Record updated On Patient id 680', 680, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:33:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1585, 'New Record inserted On Patient id 681', 681, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:36:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1586, 'Record updated On Patient id 681', 681, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:36:07', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1587, 'New Record inserted On Patient id 682', 682, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:39:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1588, 'Record updated On Patient id 682', 682, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:39:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1589, 'New Record inserted On Patient id 683', 683, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:42:51', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1590, 'Record updated On Patient id 683', 683, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 13:42:51', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1591, 'Record updated On Patient id 549', 549, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:14:59', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1592, 'New Record inserted On Patient id 684', 684, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:16:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1593, 'Record updated On Patient id 684', 684, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:16:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1594, 'New Record inserted On Patient id 685', 685, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:28:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1595, 'Record updated On Patient id 685', 685, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:28:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1596, 'New Record inserted On Patient id 686', 686, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:30:14', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1597, 'Record updated On Patient id 686', 686, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:30:14', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1598, 'New Record inserted On Patient id 687', 687, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:32:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1599, 'Record updated On Patient id 687', 687, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:32:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1600, 'New Record inserted On Patient id 688', 688, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:34:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1601, 'Record updated On Patient id 688', 688, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:34:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1602, 'New Record inserted On Patient id 689', 689, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:36:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1603, 'Record updated On Patient id 689', 689, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:36:50', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1604, 'New Record inserted On Patient id 690', 690, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:39:55', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1605, 'Record updated On Patient id 690', 690, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:39:55', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1606, 'New Record inserted On Patient id 691', 691, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:41:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1607, 'Record updated On Patient id 691', 691, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:41:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1608, 'New Record inserted On Patient id 692', 692, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:42:10', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1609, 'Record updated On Patient id 692', 692, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:42:10', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1610, 'New Record inserted On Patient id 693', 693, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:44:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1611, 'Record updated On Patient id 693', 693, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:44:22', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1612, 'New Record inserted On Patient id 694', 694, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:45:36', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1613, 'Record updated On Patient id 694', 694, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:45:36', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1614, 'New Record inserted On Patient id 695', 695, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:46:35', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1615, 'Record updated On Patient id 695', 695, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:46:35', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1616, 'New Record inserted On Patient id 696', 696, 9, 'Insert', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:47:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1617, 'Record updated On Patient id 696', 696, 9, 'Update', '105.112.124.4', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-16 14:47:34', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1618, 'New Record inserted On Patient id 697', 697, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:47:59', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1619, 'Record updated On Patient id 697', 697, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:47:59', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1620, 'Record updated On Patient id 697', 697, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:49:52', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1621, 'New Record inserted On Patient id 698', 698, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:51:19', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1622, 'Record updated On Patient id 698', 698, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:51:19', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1623, 'New Record inserted On Patient id 699', 699, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:56:04', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1624, 'Record updated On Patient id 699', 699, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 14:56:04', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1625, 'New Record inserted On Patient id 700', 700, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:01:52', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1626, 'Record updated On Patient id 700', 700, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:01:52', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1627, 'New Record inserted On Patient id 701', 701, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:14:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1628, 'Record updated On Patient id 701', 701, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:14:00', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1629, 'New Record inserted On Patient id 702', 702, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:16:28', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1630, 'Record updated On Patient id 702', 702, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:16:28', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1631, 'New Record inserted On Patient id 703', 703, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:18:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1632, 'Record updated On Patient id 703', 703, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:18:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1633, 'New Record inserted On Patient id 704', 704, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:19:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1634, 'Record updated On Patient id 704', 704, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:19:03', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1635, 'New Record inserted On Patient id 705', 705, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:20:38', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1636, 'Record updated On Patient id 705', 705, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:20:38', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1637, 'New Record inserted On Patient id 706', 706, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:24:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1638, 'Record updated On Patient id 706', 706, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:24:23', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1639, 'New Record inserted On Patient id 707', 707, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:25:54', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1640, 'Record updated On Patient id 707', 707, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:25:54', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1641, 'New Record inserted On Patient id 708', 708, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:27:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1642, 'Record updated On Patient id 708', 708, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:27:24', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1643, 'New Record inserted On Patient id 709', 709, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:28:53', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1644, 'Record updated On Patient id 709', 709, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:28:53', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1645, 'New Record inserted On Patient id 710', 710, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:30:56', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1646, 'Record updated On Patient id 710', 710, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:30:56', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1647, 'New Record inserted On Patient id 711', 711, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:33:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1648, 'Record updated On Patient id 711', 711, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:33:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1649, 'New Record inserted On Patient id 712', 712, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:37:54', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1650, 'Record updated On Patient id 712', 712, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:37:54', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1651, 'New Record inserted On Patient id 713', 713, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:40:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1652, 'Record updated On Patient id 713', 713, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:40:26', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1653, 'New Record inserted On Patient id 714', 714, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:42:11', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1654, 'Record updated On Patient id 714', 714, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:42:11', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1655, 'New Record inserted On Patient id 715', 715, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:44:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1656, 'Record updated On Patient id 715', 715, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:44:15', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1657, 'New Record inserted On Patient id 716', 716, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:49:59', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1658, 'Record updated On Patient id 716', 716, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:49:59', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1659, 'New Record inserted On Patient id 717', 717, 2, 'Insert', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:56:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1660, 'Record updated On Patient id 717', 717, 2, 'Update', '105.112.124.4', 'Windows 10', 'Firefox 109.0', '2023-02-16 15:56:09', '2023-02-16');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1661, 'New Record inserted On Patient id 718', 718, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:39:59', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1662, 'Record updated On Patient id 718', 718, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:39:59', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1663, 'New Record inserted On Patient id 719', 719, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:41:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1664, 'Record updated On Patient id 719', 719, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:41:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1665, 'New Record inserted On Patient id 720', 720, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:43:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1666, 'Record updated On Patient id 720', 720, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:43:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1667, 'New Record inserted On Patient id 721', 721, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:45:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1668, 'Record updated On Patient id 721', 721, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:45:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1669, 'New Record inserted On Patient id 722', 722, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 08:45:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1670, 'Record updated On Patient id 722', 722, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 08:45:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1671, 'New Record inserted On Patient id 723', 723, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:46:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1672, 'Record updated On Patient id 723', 723, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:46:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1673, 'New Record inserted On Patient id 724', 724, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:48:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1674, 'Record updated On Patient id 724', 724, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:48:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1675, 'New Record inserted On Patient id 725', 725, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:55:28', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1676, 'Record updated On Patient id 725', 725, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:55:28', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1677, 'Record updated On Patient id 725', 725, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 08:56:00', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1678, 'New Record inserted On Patient id 726', 726, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:00:55', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1679, 'Record updated On Patient id 726', 726, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:00:55', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1680, 'New Record inserted On Patient id 727', 727, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:01:56', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1681, 'Record updated On Patient id 727', 727, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:01:56', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1682, 'New Record inserted On Patient id 728', 728, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:06:06', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1683, 'Record updated On Patient id 728', 728, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:06:06', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1684, 'New Record inserted On Patient id 729', 729, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:13:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1685, 'Record updated On Patient id 729', 729, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:13:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1686, 'New Record inserted On Patient id 730', 730, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:16:58', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1687, 'Record updated On Patient id 730', 730, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:16:58', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1688, 'New Record inserted On Patient id 731', 731, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:22:39', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1689, 'Record updated On Patient id 731', 731, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:22:39', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1690, 'New Record inserted On Patient id 732', 732, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:23:25', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1691, 'Record updated On Patient id 732', 732, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:23:25', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1692, 'New Record inserted On Patient id 733', 733, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:25:13', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1693, 'Record updated On Patient id 733', 733, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:25:13', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1694, 'New Record inserted On Patient id 734', 734, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:25:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1695, 'Record updated On Patient id 734', 734, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:25:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1696, 'New Record inserted On Patient id 735', 735, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:27:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1697, 'Record updated On Patient id 735', 735, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:27:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1698, 'New Record inserted On Patient id 736', 736, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:28:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1699, 'Record updated On Patient id 736', 736, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:28:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1700, 'New Record inserted On Patient id 737', 737, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:29:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1701, 'Record updated On Patient id 737', 737, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:29:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1702, 'New Record inserted On Patient id 738', 738, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:32:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1703, 'Record updated On Patient id 738', 738, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:32:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1704, 'New Record inserted On Patient id 739', 739, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:37:45', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1705, 'Record updated On Patient id 739', 739, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:37:45', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1706, 'New Record inserted On Patient id 740', 740, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:37:48', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1707, 'Record updated On Patient id 740', 740, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:37:48', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1708, 'New Record inserted On Patient id 741', 741, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:39:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1709, 'Record updated On Patient id 741', 741, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:39:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1710, 'New Record inserted On Patient id 742', 742, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:39:34', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1711, 'Record updated On Patient id 742', 742, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:39:34', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1712, 'New Record inserted On Patient id 743', 743, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:40:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1713, 'Record updated On Patient id 743', 743, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:40:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1714, 'New Record inserted On Patient id 744', 744, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:40:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1715, 'Record updated On Patient id 744', 744, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 09:40:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1716, 'New Record inserted On Patient id 745', 745, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:41:50', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1717, 'Record updated On Patient id 745', 745, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:41:50', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1718, 'New Record inserted On Patient id 746', 746, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:44:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1719, 'Record updated On Patient id 746', 746, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:44:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1720, 'New Record inserted On Patient id 747', 747, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:52:00', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1721, 'Record updated On Patient id 747', 747, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 09:52:00', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1722, 'New Record inserted On Patient id 748', 748, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:00:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1723, 'Record updated On Patient id 748', 748, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:00:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1724, 'Record updated On Patient id 748', 748, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:04:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1725, 'New Record inserted On Patient id 749', 749, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:07:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1726, 'Record updated On Patient id 749', 749, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:07:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1727, 'New Record inserted On Patient id 750', 750, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:08:50', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1728, 'Record updated On Patient id 750', 750, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:08:50', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1729, 'New Record inserted On Patient id 751', 751, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:12:03', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1730, 'Record updated On Patient id 751', 751, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:12:03', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1731, 'New Record inserted On Patient id 752', 752, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:14:41', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1732, 'Record updated On Patient id 752', 752, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:14:41', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1733, 'New Record inserted On Patient id 753', 753, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:15:33', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1734, 'Record updated On Patient id 753', 753, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:15:33', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1735, 'New Record inserted On Patient id 754', 754, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:17:46', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1736, 'Record updated On Patient id 754', 754, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:17:46', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1737, 'New Record inserted On Patient id 755', 755, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:20:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1738, 'Record updated On Patient id 755', 755, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:20:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1739, 'New Record inserted On Patient id 756', 756, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:21:39', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1740, 'Record updated On Patient id 756', 756, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:21:39', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1741, 'New Record inserted On Patient id 757', 757, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:23:33', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1742, 'Record updated On Patient id 757', 757, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:23:33', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1743, 'New Record inserted On Patient id 758', 758, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:24:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1744, 'Record updated On Patient id 758', 758, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:24:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1745, 'New Record inserted On Patient id 759', 759, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:25:31', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1746, 'Record updated On Patient id 759', 759, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:25:31', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1747, 'New Record inserted On Patient id 760', 760, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:26:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1748, 'Record updated On Patient id 760', 760, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:26:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1749, 'New Record inserted On Patient id 761', 761, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:30:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1750, 'Record updated On Patient id 761', 761, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:30:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1751, 'New Record inserted On Patient id 762', 762, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:31:49', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1752, 'Record updated On Patient id 762', 762, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:31:49', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1753, 'New Record inserted On Patient id 763', 763, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:32:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1754, 'Record updated On Patient id 763', 763, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:32:05', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1755, 'New Record inserted On Patient id 764', 764, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:33:21', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1756, 'Record updated On Patient id 764', 764, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:33:21', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1757, 'New Record inserted On Patient id 765', 765, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:33:43', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1758, 'Record updated On Patient id 765', 765, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:33:43', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1759, 'New Record inserted On Patient id 766', 766, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:34:44', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1760, 'Record updated On Patient id 766', 766, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 10:34:44', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1761, 'New Record inserted On Patient id 767', 767, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:38:08', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1762, 'Record updated On Patient id 767', 767, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:38:08', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1763, 'Record updated On Patient id 767', 767, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:42:52', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1764, 'New Record inserted On Patient id 768', 768, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:46:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1765, 'Record updated On Patient id 768', 768, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:46:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1766, 'New Record inserted On Patient id 769', 769, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:47:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1767, 'Record updated On Patient id 769', 769, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:47:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1768, 'New Record inserted On Patient id 770', 770, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:48:55', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1769, 'Record updated On Patient id 770', 770, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:48:55', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1770, 'New Record inserted On Patient id 771', 771, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:50:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1771, 'Record updated On Patient id 771', 771, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:50:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1772, 'New Record inserted On Patient id 772', 772, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:51:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1773, 'Record updated On Patient id 772', 772, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:51:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1774, 'New Record inserted On Patient id 773', 773, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:57:31', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1775, 'Record updated On Patient id 773', 773, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:57:31', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1776, 'New Record inserted On Patient id 774', 774, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:59:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1777, 'Record updated On Patient id 774', 774, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 10:59:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1778, 'New Record inserted On Patient id 775', 775, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:02:29', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1779, 'Record updated On Patient id 775', 775, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:02:29', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1780, 'New Record inserted On Patient id 776', 776, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:03:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1781, 'Record updated On Patient id 776', 776, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:03:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1782, 'New Record inserted On Patient id 777', 777, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:05:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1783, 'Record updated On Patient id 777', 777, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:05:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1784, 'New Record inserted On Patient id 778', 778, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:11:08', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1785, 'Record updated On Patient id 778', 778, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:11:08', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1786, 'New Record inserted On Patient id 779', 779, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:15:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1787, 'Record updated On Patient id 779', 779, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:15:12', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1788, 'New Record inserted On Patient id 780', 780, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:18:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1789, 'Record updated On Patient id 780', 780, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:18:36', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1790, 'New Record inserted On Patient id 781', 781, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:20:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1791, 'Record updated On Patient id 781', 781, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:20:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1792, 'New Record inserted On Patient id 782', 782, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:22:02', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1793, 'Record updated On Patient id 782', 782, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:22:02', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1794, 'New Record inserted On Patient id 783', 783, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:23:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1795, 'Record updated On Patient id 783', 783, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:23:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1796, 'New Record inserted On Patient id 784', 784, 2, 'Insert', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:25:43', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1797, 'Record updated On Patient id 784', 784, 2, 'Update', '105.112.226.6', 'Windows 10', 'Firefox 109.0', '2023-02-17 11:25:43', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1798, 'New Record inserted On Patient id 785', 785, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 13:56:20', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1799, 'Record updated On Patient id 785', 785, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 13:56:20', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1800, 'New Record inserted On Patient id 786', 786, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 13:58:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1801, 'Record updated On Patient id 786', 786, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 13:58:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1802, 'New Record inserted On Patient id 787', 787, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:29:19', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1803, 'Record updated On Patient id 787', 787, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:29:19', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1804, 'New Record inserted On Patient id 788', 788, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:30:54', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1805, 'Record updated On Patient id 788', 788, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:30:54', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1806, 'New Record inserted On Patient id 789', 789, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:32:46', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1807, 'Record updated On Patient id 789', 789, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:32:46', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1808, 'New Record inserted On Patient id 790', 790, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:35:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1809, 'Record updated On Patient id 790', 790, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:35:04', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1810, 'New Record inserted On Patient id 791', 791, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:48:47', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1811, 'Record updated On Patient id 791', 791, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:48:47', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1812, 'New Record inserted On Patient id 792', 792, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:50:01', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1813, 'Record updated On Patient id 792', 792, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:50:01', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1814, 'New Record inserted On Patient id 793', 793, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:56:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1815, 'Record updated On Patient id 793', 793, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:56:15', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1816, 'New Record inserted On Patient id 794', 794, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:57:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1817, 'Record updated On Patient id 794', 794, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 14:57:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1818, 'New Record inserted On Patient id 795', 795, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:01:34', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1819, 'Record updated On Patient id 795', 795, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:01:34', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1820, 'New Record inserted On Patient id 796', 796, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:03:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1821, 'Record updated On Patient id 796', 796, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:03:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1822, 'New Record inserted On Patient id 797', 797, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:37:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1823, 'Record updated On Patient id 797', 797, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:37:35', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1824, 'New Record inserted On Patient id 798', 798, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:38:58', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1825, 'Record updated On Patient id 798', 798, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:38:58', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1826, 'New Record inserted On Patient id 799', 799, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:40:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1827, 'Record updated On Patient id 799', 799, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:40:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1828, 'New Record inserted On Patient id 800', 800, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:45:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1829, 'Record updated On Patient id 800', 800, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:45:24', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1830, 'New Record inserted On Patient id 801', 801, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:46:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1831, 'Record updated On Patient id 801', 801, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:46:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1832, 'New Record inserted On Patient id 802', 802, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:50:18', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1833, 'Record updated On Patient id 802', 802, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:50:18', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1834, 'New Record inserted On Patient id 803', 803, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:52:10', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1835, 'Record updated On Patient id 803', 803, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:52:10', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1836, 'New Record inserted On Patient id 804', 804, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:53:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1837, 'Record updated On Patient id 804', 804, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:53:57', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1838, 'New Record inserted On Patient id 805', 805, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:56:47', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1839, 'Record updated On Patient id 805', 805, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:56:47', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1840, 'New Record inserted On Patient id 806', 806, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:58:03', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1841, 'Record updated On Patient id 806', 806, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 15:58:03', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1842, 'New Record inserted On Patient id 807', 807, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:00:11', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1843, 'Record updated On Patient id 807', 807, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:00:11', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1844, 'New Record inserted On Patient id 808', 808, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:03:13', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1845, 'Record updated On Patient id 808', 808, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:03:13', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1846, 'New Record inserted On Patient id 809', 809, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:05:37', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1847, 'Record updated On Patient id 809', 809, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:05:37', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1848, 'New Record inserted On Patient id 810', 810, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:08:06', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1849, 'Record updated On Patient id 810', 810, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:08:06', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1850, 'New Record inserted On Patient id 811', 811, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:09:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1851, 'Record updated On Patient id 811', 811, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:09:40', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1852, 'New Record inserted On Patient id 812', 812, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:11:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1853, 'Record updated On Patient id 812', 812, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:11:16', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1854, 'New Record inserted On Patient id 813', 813, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:16:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1855, 'Record updated On Patient id 813', 813, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:16:23', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1856, 'New Record inserted On Patient id 814', 814, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:17:49', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1857, 'Record updated On Patient id 814', 814, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:17:49', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1858, 'New Record inserted On Patient id 815', 815, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:19:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1859, 'Record updated On Patient id 815', 815, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:19:42', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1860, 'New Record inserted On Patient id 816', 816, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:20:48', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1861, 'Record updated On Patient id 816', 816, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-17 16:20:48', '2023-02-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1862, 'Record updated On Patient id 228', 228, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 08:54:24', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1863, 'New Record inserted On Patient id 817', 817, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 08:56:37', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1864, 'Record updated On Patient id 817', 817, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 08:56:37', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1865, 'New Record inserted On Patient id 818', 818, 9, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 08:58:02', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1866, 'Record updated On Patient id 818', 818, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 08:58:02', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1867, 'Record updated On Patient id 54', 54, 9, 'Update', '105.112.226.6', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-20 10:04:43', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1868, 'New Record inserted On Unit id 25', 25, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 11:13:30', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1869, 'New Record inserted On Pathology Parameter id 3', 3, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 11:15:25', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1870, 'New Record inserted On Unit id 26', 26, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 12:39:49', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1871, 'New Record inserted On Pathology Parameter id 4', 4, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 12:51:28', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1872, 'New Record inserted On Pathology Parameter id 5', 5, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:00:26', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1873, 'New Record inserted On Pathology Parameter id 6', 6, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:13:54', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1874, 'New Record inserted On Pathology Parameter id 7', 7, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:23:29', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1875, 'New Record inserted On Charge Categories id 3', 3, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:39:22', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1876, 'New Record inserted On Pathology Parameter id 8', 8, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:39:43', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1877, 'New Record inserted On Charge Categories id 4', 4, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:40:23', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1878, 'Record deleted On Pathology Parameter id 8', 8, 3, 'Delete', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:40:41', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1879, 'New Record inserted On Charge Categories id 5', 5, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:41:25', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1880, 'New Record inserted On Pathology Parameter id 9', 9, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:46:04', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1881, 'New Record inserted On Charge Categories id 6', 6, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:47:05', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1882, 'New Record inserted On Charge Categories id 7', 7, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:48:06', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1883, 'New Record inserted On Charge Categories id 8', 8, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:48:48', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1884, 'New Record inserted On Charge Categories id 9', 9, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:49:41', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1885, 'New Record inserted On Pathology Parameter id 10', 10, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:52:08', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1886, 'New Record inserted On Pathology Parameter id 11', 11, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 13:56:46', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1887, 'New Record inserted On Pathology Parameter id 12', 12, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 14:07:18', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1888, 'New Record inserted On Pathology Parameter id 13', 13, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 14:12:45', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1889, 'New Record inserted On Unit id 27', 27, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 14:20:30', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1890, 'New Record inserted On Pathology Parameter id 14', 14, 3, 'Insert', '105.112.226.6', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-20 14:23:43', '2023-02-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1891, 'Record updated On Patient id 236', 236, 9, 'Update', '105.112.124.15', 'Windows 10', 'Chrome 109.0.0.0', '2023-02-21 13:50:55', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1892, 'New Record inserted On Unit id 28', 28, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:15:08', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1893, 'New Record inserted On Unit id 29', 29, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:15:33', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1894, 'New Record inserted On Pathology Parameter id 15', 15, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:19:15', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1895, 'New Record inserted On Pathology Parameter id 16', 16, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:26:52', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1896, 'New Record inserted On Pathology Parameter id 17', 17, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:29:50', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1897, 'New Record inserted On Pathology Parameter id 18', 18, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:37:50', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1898, 'New Record inserted On Pathology Parameter id 19', 19, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:41:34', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1899, 'New Record inserted On Pathology Parameter id 20', 20, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 15:52:30', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1900, 'New Record inserted On Pathology Parameter id 21', 21, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 16:00:15', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1901, 'New Record inserted On Pathology Parameter id 22', 22, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 16:08:11', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1902, 'New Record inserted On Pathology Parameter id 23', 23, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 16:12:48', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1903, 'New Record inserted On Unit id 30', 30, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 16:23:08', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1904, 'New Record inserted On Pathology Parameter id 24', 24, 3, 'Insert', '105.112.124.15', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-21 16:24:39', '2023-02-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1905, 'New Record inserted On Patient id 819', 819, 9, 'Insert', '105.112.113.79', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-22 09:43:56', '2023-02-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1906, 'Record updated On Patient id 819', 819, 9, 'Update', '105.112.113.79', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-22 09:43:56', '2023-02-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1907, 'Record updated On Patient id 108', 108, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 09:39:38', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1908, 'New Record inserted On Patient id 820', 820, 9, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 09:42:03', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1909, 'Record updated On Patient id 820', 820, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 09:42:03', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1910, 'New Record inserted On Patient id 821', 821, 9, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 10:00:57', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1911, 'Record updated On Patient id 821', 821, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 10:00:57', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1912, 'New Record inserted On Patient id 822', 822, 9, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 10:02:18', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1913, 'Record updated On Patient id 822', 822, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 10:02:18', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1914, 'New Record inserted On Unit id 31', 31, 3, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 11:20:55', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1915, 'New Record inserted On Pathology Parameter id 25', 25, 3, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 11:24:43', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1916, 'New Record inserted On Pathology Parameter id 26', 26, 3, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 11:33:56', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1917, 'New Record inserted On Patient id 823', 823, 9, 'Insert', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 12:31:47', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1918, 'Record updated On Patient id 823', 823, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 12:31:47', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1919, 'Record updated On Patient id 282', 282, 9, 'Update', '105.112.234.39', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 13:08:25', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1920, 'New Record inserted On Pathology Parameter id 27', 27, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 14:48:50', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1921, 'New Record inserted On Pathology Parameter id 28', 28, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 14:53:26', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1922, 'New Record inserted On Patient id 824', 824, 9, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:01:32', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1923, 'Record updated On Patient id 824', 824, 9, 'Update', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:01:32', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1924, 'New Record inserted On Pathology Parameter id 29', 29, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:02:31', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1925, 'New Record inserted On Pathology Parameter id 30', 30, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:08:21', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1926, 'New Record inserted On Patient id 825', 825, 9, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:12:58', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1927, 'Record updated On Patient id 825', 825, 9, 'Update', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:12:58', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1928, 'New Record inserted On Pathology Parameter id 31', 31, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:13:18', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1929, 'New Record inserted On Patient id 826', 826, 9, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:14:48', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1930, 'Record updated On Patient id 826', 826, 9, 'Update', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:14:48', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1931, 'New Record inserted On Pathology Parameter id 32', 32, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:18:31', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1932, 'New Record inserted On Pathology Parameter id 33', 33, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:22:07', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1933, 'New Record inserted On Pathology Parameter id 34', 34, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:33:46', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1934, 'New Record inserted On Pathology Parameter id 35', 35, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:37:29', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1935, 'New Record inserted On Pathology Parameter id 36', 36, 3, 'Insert', '105.112.113.237', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-23 15:40:24', '2023-02-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1936, 'New Record inserted On Medicine Category id 5', 5, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:11:49', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1937, 'New Record inserted On Medicine Category id 6', 6, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:12:00', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1938, 'New Record inserted On Medicine Category id 7', 7, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:12:25', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1939, 'New Record inserted On Medicine Category id 8', 8, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:12:45', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1940, 'New Record inserted On Medicine Category id 9', 9, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:12:54', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1941, 'New Record inserted On Medicine Category id 10', 10, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:13:14', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1942, 'New Record inserted On Dose Interval id 1', 1, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:14:13', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1943, 'New Record inserted On Dose Interval id 2', 2, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:14:41', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1944, 'New Record inserted On Dose Interval id 3', 3, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:14:59', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1945, 'New Record inserted On Dose Interval id 4', 4, 1, 'Insert', '105.112.224.155', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-25 19:15:31', '2023-02-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1946, 'Record updated On Patient id 507', 507, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 15:07:23', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1947, 'Record updated On Patient id 508', 508, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 15:09:24', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1948, 'Record updated On Patient id 322', 322, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 15:43:55', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1949, 'New Record inserted On Patient id 827', 827, 9, 'Insert', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 15:45:46', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1950, 'Record updated On Patient id 827', 827, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 15:45:46', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1951, 'New Record inserted On Patient id 828', 828, 9, 'Insert', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:01:14', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1952, 'Record updated On Patient id 828', 828, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:01:14', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1953, 'New Record inserted On Patient id 829', 829, 9, 'Insert', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:03:33', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1954, 'Record updated On Patient id 829', 829, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:03:33', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1955, 'New Record inserted On Patient id 830', 830, 9, 'Insert', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:05:48', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1956, 'Record updated On Patient id 830', 830, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:05:48', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1957, 'New Record inserted On Patient id 831', 831, 9, 'Insert', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:07:10', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1958, 'Record updated On Patient id 831', 831, 9, 'Update', '105.112.230.133', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-27 16:07:11', '2023-02-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1959, 'New Record inserted On Patient id 832', 832, 9, 'Insert', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:35:17', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1960, 'Record updated On Patient id 832', 832, 9, 'Update', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:35:17', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1961, 'New Record inserted On Patient id 833', 833, 9, 'Insert', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:36:28', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1962, 'Record updated On Patient id 833', 833, 9, 'Update', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:36:28', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1963, 'New Record inserted On Patient id 834', 834, 9, 'Insert', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:37:36', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1964, 'Record updated On Patient id 834', 834, 9, 'Update', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:37:36', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1965, 'Record updated On Patient id 260', 260, 9, 'Update', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:38:32', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1966, 'Record updated On Patient id 232', 232, 9, 'Update', '105.112.113.249', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 13:46:35', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1967, 'New Record inserted On Patient id 835', 835, 2, 'Insert', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:19:51', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1968, 'Record updated On Patient id 835', 835, 2, 'Update', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:19:51', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1969, 'New Record inserted On Patient id 836', 836, 2, 'Insert', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:33:12', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1970, 'Record updated On Patient id 836', 836, 2, 'Update', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:33:12', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1971, 'New Record inserted On Patient id 837', 837, 2, 'Insert', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:37:10', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1972, 'Record updated On Patient id 837', 837, 2, 'Update', '105.112.113.249', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:37:10', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1973, 'New Record inserted On Patient id 838', 838, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:42:53', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1974, 'Record updated On Patient id 838', 838, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:42:53', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1975, 'New Record inserted On Patient id 839', 839, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:44:20', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1976, 'Record updated On Patient id 839', 839, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:44:20', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1977, 'Record updated On Patient id 839', 839, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:46:29', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1978, 'Record updated On Patient id 839', 839, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:49:59', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1979, 'New Record inserted On Patient id 840', 840, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:52:43', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1980, 'Record updated On Patient id 840', 840, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:52:43', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1981, 'New Record inserted On Patient id 841', 841, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:54:15', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1982, 'Record updated On Patient id 841', 841, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:54:15', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1983, 'New Record inserted On Patient id 842', 842, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:58:18', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1984, 'Record updated On Patient id 842', 842, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 15:58:18', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1985, 'New Record inserted On Patient id 843', 843, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:01:04', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1986, 'Record updated On Patient id 843', 843, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:01:04', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1987, 'New Record inserted On Patient id 844', 844, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:12:01', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1988, 'Record updated On Patient id 844', 844, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:12:01', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1989, 'New Record inserted On Patient id 845', 845, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:17:19', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1990, 'Record updated On Patient id 845', 845, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:17:19', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1991, 'New Record inserted On Patient id 846', 846, 2, 'Insert', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:23:50', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1992, 'Record updated On Patient id 846', 846, 2, 'Update', '105.112.121.150', 'Windows 10', 'Firefox 110.0', '2023-02-28 16:23:50', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1993, 'New Record inserted On Pathology Parameter id 37', 37, 3, 'Insert', '105.112.121.150', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 16:28:43', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1994, 'Record updated On Pathology Parameter id 37', 37, 3, 'Update', '105.112.121.150', 'Windows 10', 'Chrome 110.0.0.0', '2023-02-28 16:29:15', '2023-02-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1995, 'New Record inserted On IPD id 4', 4, 9, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:30:08', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1996, 'Record updated On Bed id 1', 1, 9, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:30:08', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1997, 'New Record inserted On Patient bed history id 6', 6, 9, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:30:08', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1998, 'New Record inserted On Pathology Parameter id 38', 38, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:36:26', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1999, 'New Record inserted On Pathology Parameter id 39', 39, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:37:14', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2000, 'New Record inserted On Pathology Parameter id 40', 40, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:38:19', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2001, 'New Record inserted On Pathology Parameter id 41', 41, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:39:04', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2002, 'New Record inserted On Pathology Parameter id 42', 42, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:39:53', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2003, 'New Record inserted On Charge Categories id 10', 10, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:40:10', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2004, 'New Record inserted On Charge Type Master id 13', 13, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:40:46', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2005, 'New Record inserted On Charge Type Module id 28', 28, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:40:46', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2006, 'New Record inserted On Charge Type Module id 29', 29, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:40:46', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2007, 'New Record inserted On Pathology Parameter id 43', 43, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:40:49', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2008, 'Record updated On Charge Categories id 10', 10, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:41:11', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2009, 'New Record inserted On Pathology Parameter id 44', 44, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:41:39', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2010, 'New Record inserted On Charge Units id 2', 2, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:42:31', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2011, 'New Record inserted On Pathology Parameter id 45', 45, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:42:32', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2012, 'New Record inserted On Unit id 32', 32, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:45:20', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2013, 'New Record inserted On Pathology Parameter id 46', 46, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:46:15', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2014, 'Record updated On Unit id 32', 32, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:47:13', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2015, 'New Record inserted On Pathology Parameter id 47', 47, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:48:36', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2016, 'New Record inserted On Pathology Parameter id 48', 48, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:49:33', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2017, 'New Record inserted On Pathology Parameter id 49', 49, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:50:35', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2018, 'New Record inserted On Pathology Parameter id 50', 50, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:51:33', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2019, 'New Record inserted On Pathology Parameter id 51', 51, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 12:52:40', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2020, 'New Record inserted On Pathology Parameter id 52', 52, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:13:02', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2021, 'New Record inserted On Pathology Parameter id 53', 53, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:14:45', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2022, 'New Record inserted On Pathology Parameter id 54', 54, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:18:43', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2023, 'New Record inserted On Pathology Parameter id 55', 55, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:19:51', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2024, 'New Record inserted On Pathology Parameter id 56', 56, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:21:09', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2025, 'New Record inserted On Pathology Parameter id 57', 57, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:23:46', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2026, 'New Record inserted On Pathology Parameter id 58', 58, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:25:31', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2027, 'New Record inserted On Pathology Parameter id 59', 59, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:26:29', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2028, 'New Record inserted On Pathology Parameter id 60', 60, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:28:50', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2029, 'New Record inserted On Pathology Parameter id 61', 61, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:31:53', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2030, 'Record updated On Pathology Parameter id 61', 61, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:32:40', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2031, 'New Record inserted On Pathology Parameter id 62', 62, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:35:41', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2032, 'New Record inserted On Pathology Parameter id 63', 63, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:38:58', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2033, 'New Record inserted On Pathology Parameter id 64', 64, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:43:50', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2034, 'New Record inserted On Pathology Parameter id 65', 65, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:50:03', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2035, 'Record updated On Pathology Parameter id 65', 65, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:52:32', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2036, 'Record updated On Pathology Parameter id 29', 29, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:55:02', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2037, 'Record updated On Pathology Parameter id 30', 30, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:56:00', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2038, 'Record updated On Pathology Parameter id 33', 33, 3, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:56:34', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2039, 'New Record inserted On Pathology Parameter id 66', 66, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:57:53', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2040, 'New Record inserted On Pathology Parameter id 67', 67, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 13:58:57', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2041, 'New Record inserted On Pathology Parameter id 68', 68, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:01:01', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2042, 'New Record inserted On Pathology Parameter id 69', 69, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:02:03', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2043, 'New Record inserted On Pathology Parameter id 70', 70, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:03:33', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2044, 'New Record inserted On Pathology Parameter id 71', 71, 3, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:04:32', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2045, 'Record updated On Patient id 232', 232, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:33:43', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2046, 'Record updated On Patient id 543', 543, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:34:40', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2047, 'Record updated On Patient id 822', 822, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:35:46', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2048, 'Record updated On Patient id 232', 232, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:36:03', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2049, 'Record updated On Patient id 232', 232, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:36:43', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2050, 'New Record inserted On Read System Notification id 12', 12, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:11', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2051, 'New Record inserted On Read System Notification id 13', 13, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:13', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2052, 'New Record inserted On Read System Notification id 14', 14, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:15', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2053, 'New Record inserted On Read System Notification id 15', 15, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:17', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2054, 'New Record inserted On Read System Notification id 16', 16, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:18', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2055, 'New Record inserted On Read System Notification id 17', 17, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:19', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2056, 'New Record inserted On Read System Notification id 18', 18, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:20', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2057, 'New Record inserted On Read System Notification id 19', 19, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:21', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2058, 'New Record inserted On Read System Notification id 20', 20, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:40:22', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2059, 'Record updated On Patient id 573', 573, 9, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:43:35', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2060, 'Record updated On Patient id 574', 574, 9, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:44:30', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2061, 'Record updated On Patient id 575', 575, 9, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:45:11', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2062, 'Record deleted On Certificates id 12', 12, 1, 'Delete', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:53:28', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2063, 'New Record inserted On Staff id card id 2', 2, 1, 'Insert', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:57:16', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2064, 'Record updated On Staff id card id 2', 2, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:57:16', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2065, 'Record deleted On staff id card id 1', 1, 1, 'Delete', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:57:25', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2066, 'Record updated On Staff id card id 2', 2, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 14:57:50', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2067, 'Record updated On Email Config id 1', 1, 1, 'Update', '105.112.229.254', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-01 15:23:26', '2023-03-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2068, 'Record updated On Pathology Parameter id 43', 43, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:43:17', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2069, 'Record updated On Pathology Parameter id 46', 46, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:44:09', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2070, 'Record updated On Pathology Parameter id 52', 52, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:45:59', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2071, 'Record updated On Pathology Parameter id 53', 53, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:46:32', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2072, 'Record updated On Pathology Parameter id 52', 52, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:48:50', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2073, 'Record updated On Pathology Parameter id 55', 55, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:50:03', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2074, 'Record updated On Pathology Parameter id 55', 55, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:52:11', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2075, 'Record updated On Pathology Parameter id 55', 55, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:52:42', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2076, 'Record deleted On Pathology Parameter id 43', 43, 3, 'Delete', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:53:14', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2077, 'Record updated On Pathology Parameter id 52', 52, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:55:08', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2078, 'Record updated On Pathology Parameter id 54', 54, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 14:55:54', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2079, 'New Record inserted On Pathology Parameter id 72', 72, 3, 'Insert', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 15:01:47', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2080, 'Record updated On Pathology Parameter id 54', 54, 3, 'Update', '105.112.229.173', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-02 15:03:22', '2023-03-02');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2081, 'New Record inserted On Patient id 847', 847, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:37:06', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2082, 'Record updated On Patient id 847', 847, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:37:06', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2083, 'New Record inserted On Patient id 848', 848, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:55:08', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2084, 'Record updated On Patient id 848', 848, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:55:08', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2085, 'New Record inserted On Patient id 849', 849, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:58:12', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2086, 'Record updated On Patient id 849', 849, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 08:58:12', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2087, 'New Record inserted On Patient id 850', 850, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:02:30', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2088, 'Record updated On Patient id 850', 850, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:02:30', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2089, 'New Record inserted On Patient id 851', 851, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:11:49', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2090, 'Record updated On Patient id 851', 851, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:11:49', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2091, 'New Record inserted On Patient id 852', 852, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:14:48', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2092, 'Record updated On Patient id 852', 852, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:14:48', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2093, 'New Record inserted On Patient id 853', 853, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:18:17', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2094, 'Record updated On Patient id 853', 853, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:18:17', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2095, 'Record updated On Patient id 852', 852, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:19:36', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2096, 'Record updated On Patient id 853', 853, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:20:51', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2097, 'New Record inserted On Patient id 854', 854, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:23:04', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2098, 'Record updated On Patient id 854', 854, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:23:04', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2099, 'New Record inserted On Patient id 855', 855, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:26:03', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2100, 'Record updated On Patient id 855', 855, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:26:03', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2101, 'New Record inserted On Patient id 856', 856, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:31:04', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2102, 'Record updated On Patient id 856', 856, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:31:04', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2103, 'New Record inserted On Patient id 857', 857, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:32:55', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2104, 'Record updated On Patient id 857', 857, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:32:55', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2105, 'New Record inserted On Patient id 858', 858, 2, 'Insert', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:36:56', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2106, 'Record updated On Patient id 858', 858, 2, 'Update', '105.112.120.25', 'Windows 10', 'Firefox 110.0', '2023-03-03 09:36:56', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2107, 'Record updated On Patient id 796', 796, 9, 'Update', '105.112.113.150', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-03 16:08:07', '2023-03-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2108, 'New Record inserted On Pharmacy id 1', 1, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 05:28:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2109, 'New Record inserted On Pharmacy id 2', 2, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 05:28:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2110, 'Record deleted On Pharmacy id 2', 2, 1, 'Delete', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:19:00', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2111, 'Record deleted On Pharmacy id 1', 1, 1, 'Delete', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:19:17', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2112, 'New Record inserted On Pharmacy id 3', 3, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2113, 'New Record inserted On Pharmacy id 4', 4, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2114, 'New Record inserted On Pharmacy id 5', 5, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2115, 'New Record inserted On Pharmacy id 6', 6, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2116, 'New Record inserted On Pharmacy id 7', 7, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2117, 'New Record inserted On Pharmacy id 8', 8, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2118, 'New Record inserted On Pharmacy id 9', 9, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2119, 'New Record inserted On Pharmacy id 10', 10, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2120, 'New Record inserted On Pharmacy id 11', 11, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2121, 'New Record inserted On Pharmacy id 12', 12, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2122, 'New Record inserted On Pharmacy id 13', 13, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2123, 'New Record inserted On Pharmacy id 14', 14, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2124, 'New Record inserted On Pharmacy id 15', 15, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2125, 'New Record inserted On Pharmacy id 16', 16, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2126, 'New Record inserted On Pharmacy id 17', 17, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2127, 'New Record inserted On Pharmacy id 18', 18, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2128, 'New Record inserted On Pharmacy id 19', 19, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2129, 'New Record inserted On Pharmacy id 20', 20, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2130, 'New Record inserted On Pharmacy id 21', 21, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2131, 'New Record inserted On Pharmacy id 22', 22, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2132, 'New Record inserted On Pharmacy id 23', 23, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2133, 'New Record inserted On Pharmacy id 24', 24, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2134, 'New Record inserted On Pharmacy id 25', 25, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2135, 'New Record inserted On Pharmacy id 26', 26, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2136, 'New Record inserted On Pharmacy id 27', 27, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2137, 'New Record inserted On Pharmacy id 28', 28, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2138, 'New Record inserted On Pharmacy id 29', 29, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2139, 'New Record inserted On Pharmacy id 30', 30, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2140, 'New Record inserted On Pharmacy id 31', 31, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2141, 'New Record inserted On Pharmacy id 32', 32, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2142, 'New Record inserted On Pharmacy id 33', 33, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2143, 'New Record inserted On Pharmacy id 34', 34, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2144, 'New Record inserted On Pharmacy id 35', 35, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2145, 'New Record inserted On Pharmacy id 36', 36, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2146, 'New Record inserted On Pharmacy id 37', 37, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2147, 'New Record inserted On Pharmacy id 38', 38, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2148, 'New Record inserted On Pharmacy id 39', 39, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2149, 'New Record inserted On Pharmacy id 40', 40, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2150, 'New Record inserted On Pharmacy id 41', 41, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2151, 'New Record inserted On Pharmacy id 42', 42, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2152, 'New Record inserted On Pharmacy id 43', 43, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2153, 'New Record inserted On Pharmacy id 44', 44, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2154, 'New Record inserted On Pharmacy id 45', 45, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2155, 'New Record inserted On Pharmacy id 46', 46, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2156, 'New Record inserted On Pharmacy id 47', 47, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2157, 'New Record inserted On Pharmacy id 48', 48, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2158, 'New Record inserted On Pharmacy id 49', 49, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2159, 'New Record inserted On Pharmacy id 50', 50, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2160, 'New Record inserted On Pharmacy id 51', 51, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2161, 'New Record inserted On Pharmacy id 52', 52, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2162, 'New Record inserted On Pharmacy id 53', 53, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2163, 'New Record inserted On Pharmacy id 54', 54, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2164, 'New Record inserted On Pharmacy id 55', 55, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2165, 'New Record inserted On Pharmacy id 56', 56, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2166, 'New Record inserted On Pharmacy id 57', 57, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2167, 'New Record inserted On Pharmacy id 58', 58, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2168, 'New Record inserted On Pharmacy id 59', 59, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2169, 'New Record inserted On Pharmacy id 60', 60, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2170, 'New Record inserted On Pharmacy id 61', 61, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2171, 'New Record inserted On Pharmacy id 62', 62, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2172, 'New Record inserted On Pharmacy id 63', 63, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2173, 'New Record inserted On Pharmacy id 64', 64, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2174, 'New Record inserted On Pharmacy id 65', 65, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2175, 'New Record inserted On Pharmacy id 66', 66, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2176, 'New Record inserted On Pharmacy id 67', 67, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2177, 'New Record inserted On Pharmacy id 68', 68, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2178, 'New Record inserted On Pharmacy id 69', 69, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2179, 'New Record inserted On Pharmacy id 70', 70, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2180, 'New Record inserted On Pharmacy id 71', 71, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2181, 'New Record inserted On Pharmacy id 72', 72, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2182, 'New Record inserted On Pharmacy id 73', 73, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2183, 'New Record inserted On Pharmacy id 74', 74, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2184, 'New Record inserted On Pharmacy id 75', 75, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2185, 'New Record inserted On Pharmacy id 76', 76, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2186, 'New Record inserted On Pharmacy id 77', 77, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2187, 'New Record inserted On Pharmacy id 78', 78, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2188, 'New Record inserted On Pharmacy id 79', 79, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2189, 'New Record inserted On Pharmacy id 80', 80, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2190, 'New Record inserted On Pharmacy id 81', 81, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2191, 'New Record inserted On Pharmacy id 82', 82, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2192, 'New Record inserted On Pharmacy id 83', 83, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2193, 'New Record inserted On Pharmacy id 84', 84, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2194, 'New Record inserted On Pharmacy id 85', 85, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2195, 'New Record inserted On Pharmacy id 86', 86, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2196, 'New Record inserted On Pharmacy id 87', 87, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2197, 'New Record inserted On Pharmacy id 88', 88, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2198, 'New Record inserted On Pharmacy id 89', 89, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2199, 'New Record inserted On Pharmacy id 90', 90, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2200, 'New Record inserted On Pharmacy id 91', 91, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2201, 'New Record inserted On Pharmacy id 92', 92, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2202, 'New Record inserted On Pharmacy id 93', 93, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2203, 'New Record inserted On Pharmacy id 94', 94, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2204, 'New Record inserted On Pharmacy id 95', 95, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2205, 'New Record inserted On Pharmacy id 96', 96, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2206, 'New Record inserted On Pharmacy id 97', 97, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2207, 'New Record inserted On Pharmacy id 98', 98, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2208, 'New Record inserted On Pharmacy id 99', 99, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2209, 'New Record inserted On Pharmacy id 100', 100, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2210, 'New Record inserted On Pharmacy id 101', 101, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2211, 'New Record inserted On Pharmacy id 102', 102, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2212, 'New Record inserted On Pharmacy id 103', 103, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2213, 'New Record inserted On Pharmacy id 104', 104, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2214, 'New Record inserted On Pharmacy id 105', 105, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2215, 'New Record inserted On Pharmacy id 106', 106, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2216, 'New Record inserted On Pharmacy id 107', 107, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2217, 'New Record inserted On Pharmacy id 108', 108, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2218, 'New Record inserted On Pharmacy id 109', 109, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2219, 'New Record inserted On Pharmacy id 110', 110, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2220, 'New Record inserted On Pharmacy id 111', 111, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2221, 'New Record inserted On Pharmacy id 112', 112, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2222, 'New Record inserted On Pharmacy id 113', 113, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2223, 'New Record inserted On Pharmacy id 114', 114, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2224, 'New Record inserted On Pharmacy id 115', 115, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2225, 'New Record inserted On Pharmacy id 116', 116, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2226, 'New Record inserted On Pharmacy id 117', 117, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2227, 'New Record inserted On Pharmacy id 118', 118, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2228, 'New Record inserted On Pharmacy id 119', 119, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2229, 'New Record inserted On Pharmacy id 120', 120, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2230, 'New Record inserted On Pharmacy id 121', 121, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2231, 'New Record inserted On Pharmacy id 122', 122, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2232, 'New Record inserted On Pharmacy id 123', 123, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2233, 'New Record inserted On Pharmacy id 124', 124, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2234, 'New Record inserted On Pharmacy id 125', 125, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2235, 'New Record inserted On Pharmacy id 126', 126, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2236, 'New Record inserted On Pharmacy id 127', 127, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2237, 'New Record inserted On Pharmacy id 128', 128, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2238, 'New Record inserted On Pharmacy id 129', 129, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2239, 'New Record inserted On Pharmacy id 130', 130, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:22:13', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2240, 'New Record inserted On Pharmacy id 131', 131, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2241, 'New Record inserted On Pharmacy id 132', 132, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2242, 'New Record inserted On Pharmacy id 133', 133, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2243, 'New Record inserted On Pharmacy id 134', 134, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2244, 'New Record inserted On Pharmacy id 135', 135, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2245, 'New Record inserted On Pharmacy id 136', 136, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2246, 'New Record inserted On Pharmacy id 137', 137, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:41:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2247, 'New Record inserted On Pharmacy id 138', 138, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2248, 'New Record inserted On Pharmacy id 139', 139, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2249, 'New Record inserted On Pharmacy id 140', 140, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2250, 'New Record inserted On Pharmacy id 141', 141, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2251, 'New Record inserted On Pharmacy id 142', 142, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2252, 'New Record inserted On Pharmacy id 143', 143, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:50:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2253, 'New Record inserted On Pharmacy id 144', 144, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:54:58', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2254, 'New Record inserted On Pharmacy id 145', 145, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:54:58', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2255, 'New Record inserted On Pharmacy id 146', 146, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:54:58', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2256, 'New Record inserted On Pharmacy id 147', 147, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 06:55:31', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2257, 'New Record inserted On Pharmacy id 148', 148, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2258, 'New Record inserted On Pharmacy id 149', 149, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2259, 'New Record inserted On Pharmacy id 150', 150, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2260, 'New Record inserted On Pharmacy id 151', 151, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2261, 'New Record inserted On Pharmacy id 152', 152, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2262, 'New Record inserted On Pharmacy id 153', 153, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2263, 'New Record inserted On Pharmacy id 154', 154, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2264, 'New Record inserted On Pharmacy id 155', 155, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2265, 'New Record inserted On Pharmacy id 156', 156, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2266, 'New Record inserted On Pharmacy id 157', 157, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2267, 'New Record inserted On Pharmacy id 158', 158, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2268, 'New Record inserted On Pharmacy id 159', 159, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2269, 'New Record inserted On Pharmacy id 160', 160, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2270, 'New Record inserted On Pharmacy id 161', 161, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2271, 'New Record inserted On Pharmacy id 162', 162, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2272, 'New Record inserted On Pharmacy id 163', 163, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2273, 'New Record inserted On Pharmacy id 164', 164, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2274, 'New Record inserted On Pharmacy id 165', 165, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2275, 'New Record inserted On Pharmacy id 166', 166, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:06:11', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2276, 'New Record inserted On Pharmacy id 167', 167, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:09:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2277, 'New Record inserted On Pharmacy id 168', 168, 1, 'Insert', '105.112.121.69', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 07:09:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2278, 'New Record inserted On Patient id 859', 859, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:46:34', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2279, 'Record updated On Patient id 859', 859, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:46:34', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2280, 'New Record inserted On Patient id 860', 860, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:52:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2281, 'Record updated On Patient id 860', 860, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:52:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2282, 'New Record inserted On Patient id 861', 861, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:57:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2283, 'Record updated On Patient id 861', 861, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 08:57:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2284, 'New Record inserted On Patient id 862', 862, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:00:03', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2285, 'Record updated On Patient id 862', 862, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:00:03', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2286, 'New Record inserted On Patient id 863', 863, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:06:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2287, 'Record updated On Patient id 863', 863, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:06:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2288, 'New Record inserted On Patient id 864', 864, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:08:35', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2289, 'Record updated On Patient id 864', 864, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:08:35', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2290, 'Record updated On Patient id 849', 849, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:24:34', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2291, 'New Record inserted On Patient id 865', 865, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:24:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2292, 'Record updated On Patient id 865', 865, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:24:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2293, 'New Record inserted On Patient id 866', 866, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:28:47', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2294, 'Record updated On Patient id 866', 866, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:28:47', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2295, 'New Record inserted On Patient id 867', 867, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:33:52', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2296, 'Record updated On Patient id 867', 867, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:33:52', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2297, 'New Record inserted On Patient id 868', 868, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:39:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2298, 'Record updated On Patient id 868', 868, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:39:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2299, 'New Record inserted On Patient id 869', 869, 2, 'Insert', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:58:52', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2300, 'Record updated On Patient id 869', 869, 2, 'Update', '105.112.121.69', 'Windows 10', 'Firefox 110.0', '2023-03-06 09:58:52', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2301, 'Record updated On Patient id 48', 48, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:05:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2302, 'New Record inserted On Patient id 870', 870, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:08:07', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2303, 'Record updated On Patient id 870', 870, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:08:07', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2304, 'Record updated On Patient id 870', 870, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:09:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2305, 'New Record inserted On Patient id 871', 871, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:17:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2306, 'Record updated On Patient id 871', 871, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:17:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2307, 'Record updated On Patient id 127', 127, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:31:53', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2308, 'New Record inserted On Patient id 872', 872, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:35:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2309, 'Record updated On Patient id 872', 872, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:35:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2310, 'New Record inserted On Pharmacy id 169', 169, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2311, 'New Record inserted On Pharmacy id 170', 170, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2312, 'New Record inserted On Pharmacy id 171', 171, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2313, 'New Record inserted On Pharmacy id 172', 172, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2314, 'New Record inserted On Pharmacy id 173', 173, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2315, 'New Record inserted On Pharmacy id 174', 174, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2316, 'New Record inserted On Pharmacy id 175', 175, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2317, 'New Record inserted On Pharmacy id 176', 176, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2318, 'New Record inserted On Pharmacy id 177', 177, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2319, 'New Record inserted On Pharmacy id 178', 178, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2320, 'New Record inserted On Pharmacy id 179', 179, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2321, 'New Record inserted On Pharmacy id 180', 180, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2322, 'New Record inserted On Pharmacy id 181', 181, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2323, 'New Record inserted On Pharmacy id 182', 182, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2324, 'New Record inserted On Pharmacy id 183', 183, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2325, 'New Record inserted On Pharmacy id 184', 184, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2326, 'New Record inserted On Pharmacy id 185', 185, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2327, 'New Record inserted On Pharmacy id 186', 186, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2328, 'New Record inserted On Pharmacy id 187', 187, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2329, 'New Record inserted On Pharmacy id 188', 188, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2330, 'New Record inserted On Pharmacy id 189', 189, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2331, 'New Record inserted On Pharmacy id 190', 190, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2332, 'New Record inserted On Pharmacy id 191', 191, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2333, 'New Record inserted On Pharmacy id 192', 192, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2334, 'New Record inserted On Pharmacy id 193', 193, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2335, 'New Record inserted On Pharmacy id 194', 194, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2336, 'New Record inserted On Pharmacy id 195', 195, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2337, 'New Record inserted On Pharmacy id 196', 196, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2338, 'New Record inserted On Pharmacy id 197', 197, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2339, 'New Record inserted On Pharmacy id 198', 198, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2340, 'New Record inserted On Pharmacy id 199', 199, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2341, 'New Record inserted On Pharmacy id 200', 200, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2342, 'New Record inserted On Pharmacy id 201', 201, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2343, 'New Record inserted On Pharmacy id 202', 202, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2344, 'New Record inserted On Pharmacy id 203', 203, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2345, 'New Record inserted On Pharmacy id 204', 204, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2346, 'New Record inserted On Pharmacy id 205', 205, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2347, 'New Record inserted On Pharmacy id 206', 206, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2348, 'New Record inserted On Pharmacy id 207', 207, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2349, 'New Record inserted On Pharmacy id 208', 208, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2350, 'New Record inserted On Pharmacy id 209', 209, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2351, 'New Record inserted On Pharmacy id 210', 210, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2352, 'New Record inserted On Pharmacy id 211', 211, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2353, 'New Record inserted On Pharmacy id 212', 212, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2354, 'New Record inserted On Pharmacy id 213', 213, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2355, 'New Record inserted On Pharmacy id 214', 214, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2356, 'New Record inserted On Pharmacy id 215', 215, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2357, 'New Record inserted On Pharmacy id 216', 216, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2358, 'New Record inserted On Pharmacy id 217', 217, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2359, 'New Record inserted On Pharmacy id 218', 218, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2360, 'New Record inserted On Pharmacy id 219', 219, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2361, 'New Record inserted On Pharmacy id 220', 220, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2362, 'New Record inserted On Pharmacy id 221', 221, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2363, 'New Record inserted On Pharmacy id 222', 222, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2364, 'New Record inserted On Pharmacy id 223', 223, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2365, 'New Record inserted On Pharmacy id 224', 224, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2366, 'New Record inserted On Pharmacy id 225', 225, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2367, 'New Record inserted On Pharmacy id 226', 226, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2368, 'New Record inserted On Pharmacy id 227', 227, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2369, 'New Record inserted On Pharmacy id 228', 228, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2370, 'New Record inserted On Pharmacy id 229', 229, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2371, 'New Record inserted On Pharmacy id 230', 230, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2372, 'New Record inserted On Pharmacy id 231', 231, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2373, 'New Record inserted On Pharmacy id 232', 232, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2374, 'New Record inserted On Pharmacy id 233', 233, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2375, 'New Record inserted On Pharmacy id 234', 234, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2376, 'New Record inserted On Pharmacy id 235', 235, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2377, 'New Record inserted On Pharmacy id 236', 236, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2378, 'New Record inserted On Pharmacy id 237', 237, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2379, 'New Record inserted On Pharmacy id 238', 238, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2380, 'New Record inserted On Pharmacy id 239', 239, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2381, 'New Record inserted On Pharmacy id 240', 240, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2382, 'New Record inserted On Pharmacy id 241', 241, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2383, 'New Record inserted On Pharmacy id 242', 242, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2384, 'New Record inserted On Pharmacy id 243', 243, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2385, 'New Record inserted On Pharmacy id 244', 244, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2386, 'New Record inserted On Pharmacy id 245', 245, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2387, 'New Record inserted On Pharmacy id 246', 246, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2388, 'New Record inserted On Pharmacy id 247', 247, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2389, 'New Record inserted On Pharmacy id 248', 248, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2390, 'New Record inserted On Pharmacy id 249', 249, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2391, 'New Record inserted On Pharmacy id 250', 250, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2392, 'New Record inserted On Pharmacy id 251', 251, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2393, 'New Record inserted On Pharmacy id 252', 252, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2394, 'New Record inserted On Pharmacy id 253', 253, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2395, 'New Record inserted On Pharmacy id 254', 254, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2396, 'New Record inserted On Pharmacy id 255', 255, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2397, 'New Record inserted On Pharmacy id 256', 256, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2398, 'New Record inserted On Pharmacy id 257', 257, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2399, 'New Record inserted On Pharmacy id 258', 258, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2400, 'New Record inserted On Pharmacy id 259', 259, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2401, 'New Record inserted On Pharmacy id 260', 260, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2402, 'New Record inserted On Pharmacy id 261', 261, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2403, 'New Record inserted On Pharmacy id 262', 262, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2404, 'New Record inserted On Pharmacy id 263', 263, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2405, 'New Record inserted On Pharmacy id 264', 264, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2406, 'New Record inserted On Pharmacy id 265', 265, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2407, 'New Record inserted On Pharmacy id 266', 266, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2408, 'New Record inserted On Pharmacy id 267', 267, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2409, 'New Record inserted On Pharmacy id 268', 268, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2410, 'New Record inserted On Pharmacy id 269', 269, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2411, 'New Record inserted On Pharmacy id 270', 270, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2412, 'New Record inserted On Pharmacy id 271', 271, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2413, 'New Record inserted On Pharmacy id 272', 272, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2414, 'New Record inserted On Pharmacy id 273', 273, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2415, 'New Record inserted On Pharmacy id 274', 274, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2416, 'New Record inserted On Pharmacy id 275', 275, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2417, 'New Record inserted On Pharmacy id 276', 276, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2418, 'New Record inserted On Pharmacy id 277', 277, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2419, 'New Record inserted On Pharmacy id 278', 278, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2420, 'New Record inserted On Pharmacy id 279', 279, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2421, 'New Record inserted On Pharmacy id 280', 280, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2422, 'New Record inserted On Pharmacy id 281', 281, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2423, 'New Record inserted On Pharmacy id 282', 282, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2424, 'New Record inserted On Pharmacy id 283', 283, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:37:28', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2425, 'Record updated On Medicine Category id 9', 9, 1, 'Update', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:43:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2426, 'New Record inserted On Patient id 873', 873, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:43:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2427, 'Record updated On Patient id 873', 873, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:43:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2428, 'New Record inserted On Pharmacy id 284', 284, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:46:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2429, 'New Record inserted On Pharmacy id 285', 285, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:46:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2430, 'New Record inserted On Pharmacy id 286', 286, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:46:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2431, 'New Record inserted On Patient id 874', 874, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:56:25', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2432, 'Record updated On Patient id 874', 874, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 11:56:25', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2433, 'New Record inserted On Read System Notification id 21', 21, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2434, 'New Record inserted On Read System Notification id 22', 22, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:23', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2435, 'New Record inserted On Read System Notification id 23', 23, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:24', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2436, 'New Record inserted On Read System Notification id 24', 24, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:26', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2437, 'New Record inserted On Read System Notification id 25', 25, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:32', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2438, 'New Record inserted On Read System Notification id 26', 26, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:50', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2439, 'New Record inserted On Read System Notification id 27', 27, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:58:59', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2440, 'New Record inserted On Read System Notification id 28', 28, 1, 'Insert', '105.112.225.229', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 11:59:07', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2441, 'New Record inserted On Patient id 875', 875, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:04:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2442, 'Record updated On Patient id 875', 875, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:04:44', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2443, 'New Record inserted On Patient id 876', 876, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:09:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2444, 'Record updated On Patient id 876', 876, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:09:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2445, 'New Record inserted On Patient id 877', 877, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:14:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2446, 'Record updated On Patient id 877', 877, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:14:08', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2447, 'New Record inserted On Patient id 878', 878, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:16:50', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2448, 'Record updated On Patient id 878', 878, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:16:50', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2449, 'New Record inserted On Patient id 879', 879, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:19:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2450, 'Record updated On Patient id 879', 879, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:19:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2451, 'New Record inserted On Patient id 880', 880, 2, 'Insert', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:22:01', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2452, 'Record updated On Patient id 880', 880, 2, 'Update', '105.112.225.229', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:22:01', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2453, 'New Record inserted On Patient id 881', 881, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:35:32', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2454, 'Record updated On Patient id 881', 881, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 12:35:32', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2455, 'New Record inserted On Medicine Category id 11', 11, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:52:24', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2456, 'New Record inserted On Pharmacy id 287', 287, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2457, 'New Record inserted On Pharmacy id 288', 288, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2458, 'New Record inserted On Pharmacy id 289', 289, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2459, 'New Record inserted On Pharmacy id 290', 290, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2460, 'New Record inserted On Pharmacy id 291', 291, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2461, 'New Record inserted On Pharmacy id 292', 292, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2462, 'New Record inserted On Pharmacy id 293', 293, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2463, 'New Record inserted On Pharmacy id 294', 294, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2464, 'New Record inserted On Pharmacy id 295', 295, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2465, 'New Record inserted On Pharmacy id 296', 296, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2466, 'New Record inserted On Pharmacy id 297', 297, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2467, 'New Record inserted On Pharmacy id 298', 298, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2468, 'New Record inserted On Pharmacy id 299', 299, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2469, 'New Record inserted On Pharmacy id 300', 300, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2470, 'New Record inserted On Pharmacy id 301', 301, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2471, 'New Record inserted On Pharmacy id 302', 302, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2472, 'New Record inserted On Pharmacy id 303', 303, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2473, 'New Record inserted On Pharmacy id 304', 304, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2474, 'New Record inserted On Pharmacy id 305', 305, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2475, 'New Record inserted On Pharmacy id 306', 306, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2476, 'New Record inserted On Pharmacy id 307', 307, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2477, 'New Record inserted On Pharmacy id 308', 308, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2478, 'New Record inserted On Pharmacy id 309', 309, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2479, 'New Record inserted On Pharmacy id 310', 310, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2480, 'New Record inserted On Pharmacy id 311', 311, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2481, 'New Record inserted On Pharmacy id 312', 312, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2482, 'New Record inserted On Pharmacy id 313', 313, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2483, 'New Record inserted On Pharmacy id 314', 314, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2484, 'New Record inserted On Pharmacy id 315', 315, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2485, 'New Record inserted On Pharmacy id 316', 316, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2486, 'New Record inserted On Pharmacy id 317', 317, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2487, 'New Record inserted On Pharmacy id 318', 318, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2488, 'New Record inserted On Pharmacy id 319', 319, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2489, 'New Record inserted On Pharmacy id 320', 320, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2490, 'New Record inserted On Pharmacy id 321', 321, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2491, 'New Record inserted On Pharmacy id 322', 322, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2492, 'New Record inserted On Pharmacy id 323', 323, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2493, 'New Record inserted On Pharmacy id 324', 324, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2494, 'New Record inserted On Pharmacy id 325', 325, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2495, 'New Record inserted On Pharmacy id 326', 326, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2496, 'New Record inserted On Pharmacy id 327', 327, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2497, 'New Record inserted On Pharmacy id 328', 328, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2498, 'New Record inserted On Pharmacy id 329', 329, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2499, 'New Record inserted On Pharmacy id 330', 330, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2500, 'New Record inserted On Pharmacy id 331', 331, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2501, 'New Record inserted On Pharmacy id 332', 332, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2502, 'New Record inserted On Pharmacy id 333', 333, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2503, 'New Record inserted On Pharmacy id 334', 334, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2504, 'New Record inserted On Pharmacy id 335', 335, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2505, 'New Record inserted On Pharmacy id 336', 336, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2506, 'New Record inserted On Pharmacy id 337', 337, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2507, 'New Record inserted On Pharmacy id 338', 338, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2508, 'New Record inserted On Pharmacy id 339', 339, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2509, 'New Record inserted On Pharmacy id 340', 340, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2510, 'New Record inserted On Pharmacy id 341', 341, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2511, 'New Record inserted On Pharmacy id 342', 342, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2512, 'New Record inserted On Pharmacy id 343', 343, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2513, 'New Record inserted On Pharmacy id 344', 344, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2514, 'New Record inserted On Pharmacy id 345', 345, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2515, 'New Record inserted On Pharmacy id 346', 346, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2516, 'New Record inserted On Pharmacy id 347', 347, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2517, 'New Record inserted On Pharmacy id 348', 348, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2518, 'New Record inserted On Pharmacy id 349', 349, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2519, 'New Record inserted On Pharmacy id 350', 350, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2520, 'New Record inserted On Pharmacy id 351', 351, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2521, 'New Record inserted On Pharmacy id 352', 352, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2522, 'New Record inserted On Pharmacy id 353', 353, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2523, 'New Record inserted On Pharmacy id 354', 354, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2524, 'New Record inserted On Pharmacy id 355', 355, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2525, 'New Record inserted On Pharmacy id 356', 356, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2526, 'New Record inserted On Pharmacy id 357', 357, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2527, 'New Record inserted On Pharmacy id 358', 358, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2528, 'New Record inserted On Pharmacy id 359', 359, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2529, 'New Record inserted On Pharmacy id 360', 360, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2530, 'New Record inserted On Pharmacy id 361', 361, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2531, 'New Record inserted On Pharmacy id 362', 362, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2532, 'New Record inserted On Pharmacy id 363', 363, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2533, 'New Record inserted On Pharmacy id 364', 364, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2534, 'New Record inserted On Pharmacy id 365', 365, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2535, 'New Record inserted On Pharmacy id 366', 366, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2536, 'New Record inserted On Pharmacy id 367', 367, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2537, 'New Record inserted On Pharmacy id 368', 368, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2538, 'New Record inserted On Pharmacy id 369', 369, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2539, 'New Record inserted On Pharmacy id 370', 370, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2540, 'New Record inserted On Pharmacy id 371', 371, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2541, 'New Record inserted On Pharmacy id 372', 372, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2542, 'New Record inserted On Pharmacy id 373', 373, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2543, 'New Record inserted On Pharmacy id 374', 374, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2544, 'New Record inserted On Pharmacy id 375', 375, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2545, 'New Record inserted On Pharmacy id 376', 376, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2546, 'New Record inserted On Pharmacy id 377', 377, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2547, 'New Record inserted On Pharmacy id 378', 378, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2548, 'New Record inserted On Pharmacy id 379', 379, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2549, 'New Record inserted On Pharmacy id 380', 380, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2550, 'New Record inserted On Pharmacy id 381', 381, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2551, 'New Record inserted On Pharmacy id 382', 382, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2552, 'New Record inserted On Pharmacy id 383', 383, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2553, 'New Record inserted On Pharmacy id 384', 384, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2554, 'New Record inserted On Pharmacy id 385', 385, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2555, 'New Record inserted On Pharmacy id 386', 386, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2556, 'New Record inserted On Pharmacy id 387', 387, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2557, 'New Record inserted On Pharmacy id 388', 388, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2558, 'New Record inserted On Pharmacy id 389', 389, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2559, 'New Record inserted On Pharmacy id 390', 390, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2560, 'New Record inserted On Pharmacy id 391', 391, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2561, 'New Record inserted On Pharmacy id 392', 392, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2562, 'New Record inserted On Pharmacy id 393', 393, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2563, 'New Record inserted On Pharmacy id 394', 394, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2564, 'New Record inserted On Pharmacy id 395', 395, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2565, 'New Record inserted On Pharmacy id 396', 396, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2566, 'New Record inserted On Pharmacy id 397', 397, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2567, 'New Record inserted On Pharmacy id 398', 398, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2568, 'New Record inserted On Pharmacy id 399', 399, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2569, 'New Record inserted On Pharmacy id 400', 400, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2570, 'New Record inserted On Pharmacy id 401', 401, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2571, 'New Record inserted On Pharmacy id 402', 402, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 12:53:14', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2572, 'New Record inserted On Pharmacy id 403', 403, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:03', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2573, 'New Record inserted On Pharmacy id 404', 404, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2574, 'New Record inserted On Pharmacy id 405', 405, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2575, 'New Record inserted On Pharmacy id 406', 406, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2576, 'New Record inserted On Pharmacy id 407', 407, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2577, 'New Record inserted On Pharmacy id 408', 408, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2578, 'New Record inserted On Pharmacy id 409', 409, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2579, 'New Record inserted On Pharmacy id 410', 410, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2580, 'New Record inserted On Pharmacy id 411', 411, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2581, 'New Record inserted On Pharmacy id 412', 412, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2582, 'New Record inserted On Pharmacy id 413', 413, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2583, 'New Record inserted On Pharmacy id 414', 414, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2584, 'New Record inserted On Pharmacy id 415', 415, 1, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 13:12:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2585, 'New Record inserted On Patient id 882', 882, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:19:01', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2586, 'Record updated On Patient id 882', 882, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:19:01', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2587, 'New Record inserted On Patient id 883', 883, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:35:16', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2588, 'Record updated On Patient id 883', 883, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:35:16', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2589, 'New Record inserted On Patient id 884', 884, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:37:24', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2590, 'Record updated On Patient id 884', 884, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 13:37:24', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2591, 'New Record inserted On Patient id 885', 885, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:16:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2592, 'Record updated On Patient id 885', 885, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:16:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2593, 'New Record inserted On Patient id 886', 886, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:21:51', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2594, 'Record updated On Patient id 886', 886, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:21:51', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2595, 'New Record inserted On Patient id 887', 887, 9, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 14:22:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2596, 'Record updated On Patient id 887', 887, 9, 'Update', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 14:22:54', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2597, 'New Record inserted On Patient id 888', 888, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:24:58', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2598, 'Record updated On Patient id 888', 888, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:24:58', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2599, 'New Record inserted On IPD id 5', 5, 9, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 14:27:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2600, 'Record updated On Bed id 4', 4, 9, 'Update', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 14:27:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2601, 'New Record inserted On Patient bed history id 7', 7, 9, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 14:27:04', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2602, 'New Record inserted On Patient id 889', 889, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:33:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2603, 'Record updated On Patient id 889', 889, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:33:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2604, 'New Record inserted On Patient id 890', 890, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:38:35', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2605, 'Record updated On Patient id 890', 890, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:38:35', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2606, 'Record updated On Patient id 890', 890, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:39:18', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2607, 'New Record inserted On Patient id 891', 891, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:44:09', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2608, 'Record updated On Patient id 891', 891, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 14:44:09', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2609, 'New Record inserted On Patient id 892', 892, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:04:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2610, 'Record updated On Patient id 892', 892, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:04:15', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2611, 'New Record inserted On Patient id 893', 893, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:08:09', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2612, 'Record updated On Patient id 893', 893, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:08:09', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2613, 'New Record inserted On Patient id 894', 894, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:10:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2614, 'Record updated On Patient id 894', 894, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:10:05', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2615, 'New Record inserted On Patient id 895', 895, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:12:26', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2616, 'Record updated On Patient id 895', 895, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:12:26', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2617, 'New Record inserted On Patient id 896', 896, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:15:00', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2618, 'Record updated On Patient id 896', 896, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:15:00', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2619, 'New Record inserted On Patient id 897', 897, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:19:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2620, 'Record updated On Patient id 897', 897, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:19:20', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2621, 'New Record inserted On Patient id 898', 898, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:24:27', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2622, 'Record updated On Patient id 898', 898, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:24:27', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2623, 'New Record inserted On Patient id 899', 899, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:26:33', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2624, 'Record updated On Patient id 899', 899, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:26:33', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2625, 'Record updated On Patient id 899', 899, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:40:59', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2626, 'New Record inserted On Patient id 900', 900, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:46:47', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2627, 'Record updated On Patient id 900', 900, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 15:46:47', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2628, 'Record updated On Patient id 507', 507, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 16:03:45', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2629, 'Record updated On Patient id 508', 508, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 16:04:19', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2630, 'New Record inserted On Patient id 901', 901, 9, 'Insert', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 16:09:37', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2631, 'Record updated On Patient id 901', 901, 9, 'Update', '105.112.117.178', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-06 16:09:37', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2632, 'New Record inserted On Patient id 902', 902, 2, 'Insert', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 16:14:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2633, 'Record updated On Patient id 902', 902, 2, 'Update', '105.112.117.178', 'Windows 10', 'Firefox 110.0', '2023-03-06 16:14:38', '2023-03-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2634, 'New Record inserted On Patient id 903', 903, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:29:20', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2635, 'Record updated On Patient id 903', 903, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:29:20', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2636, 'New Record inserted On Patient id 904', 904, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:31:47', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2637, 'Record updated On Patient id 904', 904, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:31:47', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2638, 'New Record inserted On Patient id 905', 905, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:34:58', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2639, 'Record updated On Patient id 905', 905, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:34:58', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2640, 'New Record inserted On Patient id 906', 906, 9, 'Insert', '105.112.120.86', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-07 09:43:17', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2641, 'Record updated On Patient id 906', 906, 9, 'Update', '105.112.120.86', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-07 09:43:17', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2642, 'New Record inserted On Patient id 907', 907, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:48:32', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2643, 'Record updated On Patient id 907', 907, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:48:32', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2644, 'New Record inserted On Patient id 908', 908, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:59:28', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2645, 'Record updated On Patient id 908', 908, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 09:59:28', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2646, 'New Record inserted On Patient id 909', 909, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:05:36', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2647, 'Record updated On Patient id 909', 909, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:05:36', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2648, 'New Record inserted On Patient id 910', 910, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:23:44', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2649, 'Record updated On Patient id 910', 910, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:23:44', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2650, 'New Record inserted On Patient id 911', 911, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:33:50', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2651, 'Record updated On Patient id 911', 911, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:33:50', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2652, 'New Record inserted On Patient id 912', 912, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:40:12', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2653, 'Record updated On Patient id 912', 912, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:40:12', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2654, 'New Record inserted On Patient id 913', 913, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:48:45', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2655, 'Record updated On Patient id 913', 913, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:48:45', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2656, 'New Record inserted On Patient id 914', 914, 2, 'Insert', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:51:10', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2657, 'Record updated On Patient id 914', 914, 2, 'Update', '105.112.120.86', 'Windows 10', 'Firefox 110.0', '2023-03-07 10:51:10', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2658, 'New Record inserted On Patient id 915', 915, 9, 'Insert', '105.112.112.190', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-07 11:46:31', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2659, 'Record updated On Patient id 915', 915, 9, 'Update', '105.112.112.190', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-07 11:46:31', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2660, 'New Record inserted On Patient id 916', 916, 2, 'Insert', '105.112.115.92', 'Windows 10', 'Firefox 110.0', '2023-03-07 14:46:37', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2661, 'Record updated On Patient id 916', 916, 2, 'Update', '105.112.115.92', 'Windows 10', 'Firefox 110.0', '2023-03-07 14:46:37', '2023-03-07');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2662, 'New Record inserted On Patient id 917', 917, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:14:29', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2663, 'Record updated On Patient id 917', 917, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:14:29', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2664, 'Record updated On Patient id 917', 917, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:20:05', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2665, 'New Record inserted On Patient id 918', 918, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:23:24', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2666, 'Record updated On Patient id 918', 918, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:23:24', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2667, 'Record updated On Patient id 918', 918, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:28:37', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2668, 'New Record inserted On Patient id 919', 919, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:53:32', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2669, 'Record updated On Patient id 919', 919, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:53:32', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2670, 'New Record inserted On Patient id 920', 920, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:55:53', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2671, 'Record updated On Patient id 920', 920, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:55:53', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2672, 'New Record inserted On Patient id 921', 921, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:58:39', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2673, 'Record updated On Patient id 921', 921, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 09:58:39', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2674, 'New Record inserted On Patient id 922', 922, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:00:22', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2675, 'Record updated On Patient id 922', 922, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:00:22', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2676, 'New Record inserted On Patient id 923', 923, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:02:24', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2677, 'Record updated On Patient id 923', 923, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:02:24', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2678, 'New Record inserted On Patient id 924', 924, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:08:21', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2679, 'Record updated On Patient id 924', 924, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:08:21', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2680, 'New Record inserted On Patient id 925', 925, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:11:15', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2681, 'Record updated On Patient id 925', 925, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:11:15', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2682, 'New Record inserted On Patient id 926', 926, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:13:42', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2683, 'Record updated On Patient id 926', 926, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:13:42', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2684, 'New Record inserted On Patient id 927', 927, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:15:44', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2685, 'Record updated On Patient id 927', 927, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:15:44', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2686, 'New Record inserted On Patient id 928', 928, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:18:32', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2687, 'Record updated On Patient id 928', 928, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:18:32', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2688, 'New Record inserted On Patient id 929', 929, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:26:42', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2689, 'Record updated On Patient id 929', 929, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:26:42', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2690, 'New Record inserted On Patient id 930', 930, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:55:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2691, 'Record updated On Patient id 930', 930, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 10:55:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2692, 'New Record inserted On IPD id 6', 6, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:09:36', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2693, 'Record updated On Bed id 2', 2, 9, 'Update', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:09:36', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2694, 'New Record inserted On Patient bed history id 8', 8, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:09:36', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2695, 'New Record inserted On Patient id 931', 931, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:10:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2696, 'Record updated On Patient id 931', 931, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:10:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2697, 'New Record inserted On Patient id 932', 932, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:12:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2698, 'Record updated On Patient id 932', 932, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:12:20', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2699, 'New Record inserted On Patient id 933', 933, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:12:34', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2700, 'Record updated On Patient id 933', 933, 9, 'Update', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:12:34', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2701, 'New Record inserted On Patient id 934', 934, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:14:21', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2702, 'Record updated On Patient id 934', 934, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:14:21', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2703, 'New Record inserted On IPD id 7', 7, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:23:29', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2704, 'Record updated On Bed id 3', 3, 9, 'Update', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:23:29', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2705, 'New Record inserted On Patient bed history id 9', 9, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:23:29', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2706, 'New Record inserted On Patient id 935', 935, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:27:59', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2707, 'Record updated On Patient id 935', 935, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:27:59', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2708, 'New Record inserted On Patient id 936', 936, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:32:49', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2709, 'Record updated On Patient id 936', 936, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:32:49', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2710, 'New Record inserted On Patient id 937', 937, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:35:25', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2711, 'Record updated On Patient id 937', 937, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:35:25', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2712, 'New Record inserted On Patient id 938', 938, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:38:54', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2713, 'Record updated On Patient id 938', 938, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:38:54', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2714, 'New Record inserted On Patient id 939', 939, 2, 'Insert', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:44:03', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2715, 'Record updated On Patient id 939', 939, 2, 'Update', '105.112.121.24', 'Windows 10', 'Firefox 110.0', '2023-03-09 11:44:03', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2716, 'New Record inserted On Patient id 940', 940, 9, 'Insert', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:59:13', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2717, 'Record updated On Patient id 940', 940, 9, 'Update', '105.112.121.24', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 11:59:13', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2718, 'New Record inserted On Patient id 941', 941, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:06:56', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2719, 'Record updated On Patient id 941', 941, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:06:56', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2720, 'Record updated On Email Config id 1', 1, 1, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:08:40', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2721, 'New Record inserted On Patient id 942', 942, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:09:28', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2722, 'Record updated On Patient id 942', 942, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:09:28', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2723, 'New Record inserted On Patient id 943', 943, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:12:16', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2724, 'Record updated On Patient id 943', 943, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:12:16', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2725, 'New Record inserted On Patient id 944', 944, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:14:47', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2726, 'Record updated On Patient id 944', 944, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:14:47', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2727, 'New Record inserted On Patient id 945', 945, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:17:19', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2728, 'Record updated On Patient id 945', 945, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:17:19', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2729, 'New Record inserted On Patient id 946', 946, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:18:52', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2730, 'Record updated On Patient id 946', 946, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:18:52', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2731, 'New Record inserted On Patient id 947', 947, 9, 'Insert', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:20:51', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2732, 'Record updated On Patient id 947', 947, 9, 'Update', '105.112.113.158', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-09 13:20:51', '2023-03-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2733, 'New Record inserted On Patient id 948', 948, 2, 'Insert', '105.112.112.5', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:47:49', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2734, 'Record updated On Patient id 948', 948, 2, 'Update', '105.112.112.5', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:47:49', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2735, 'New Record inserted On Patient id 949', 949, 2, 'Insert', '105.112.112.5', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:53:53', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2736, 'Record updated On Patient id 949', 949, 2, 'Update', '105.112.112.5', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:53:53', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2737, 'New Record inserted On Patient id 950', 950, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:57:37', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2738, 'Record updated On Patient id 950', 950, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:57:37', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2739, 'New Record inserted On Patient id 951', 951, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:59:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2740, 'Record updated On Patient id 951', 951, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 08:59:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2741, 'New Record inserted On Patient id 952', 952, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:03:20', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2742, 'Record updated On Patient id 952', 952, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:03:20', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2743, 'New Record inserted On Patient id 953', 953, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:05:17', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2744, 'Record updated On Patient id 953', 953, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:05:17', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2745, 'New Record inserted On Patient id 954', 954, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:06:31', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2746, 'Record updated On Patient id 954', 954, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:06:31', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2747, 'New Record inserted On Patient id 955', 955, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:07:59', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2748, 'Record updated On Patient id 955', 955, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:07:59', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2749, 'New Record inserted On Patient id 956', 956, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:08:58', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2750, 'Record updated On Patient id 956', 956, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:08:58', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2751, 'New Record inserted On IPD id 8', 8, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:10:09', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2752, 'Record updated On Bed id 2', 2, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:10:09', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2753, 'New Record inserted On Patient bed history id 10', 10, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:10:09', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2754, 'New Record inserted On Patient id 957', 957, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:10:56', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2755, 'Record updated On Patient id 957', 957, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:10:56', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2756, 'New Record inserted On Patient id 958', 958, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:12:44', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2757, 'Record updated On Patient id 958', 958, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:12:44', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2758, 'New Record inserted On Patient id 959', 959, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:14:17', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2759, 'Record updated On Patient id 959', 959, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:14:17', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2760, 'New Record inserted On Patient id 960', 960, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:16:37', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2761, 'Record updated On Patient id 960', 960, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:16:37', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2762, 'New Record inserted On Patient id 961', 961, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:18:44', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2763, 'Record updated On Patient id 961', 961, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:18:44', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2764, 'New Record inserted On Patient id 962', 962, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:20:27', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2765, 'Record updated On Patient id 962', 962, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:20:27', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2766, 'New Record inserted On Patient id 963', 963, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:21:00', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2767, 'Record updated On Patient id 963', 963, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:21:00', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2768, 'New Record inserted On Patient id 964', 964, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:21:58', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2769, 'Record updated On Patient id 964', 964, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:21:58', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2770, 'New Record inserted On Patient id 965', 965, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:22:53', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2771, 'Record updated On Patient id 965', 965, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:22:53', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2772, 'New Record inserted On Patient id 966', 966, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:24:08', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2773, 'Record updated On Patient id 966', 966, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:24:08', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2774, 'New Record inserted On Patient id 967', 967, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:24:13', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2775, 'Record updated On Patient id 967', 967, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:24:13', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2776, 'New Record inserted On Patient id 968', 968, 9, 'Insert', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:25:25', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2777, 'Record updated On Patient id 968', 968, 9, 'Update', '105.112.123.106', 'Windows 10', 'Chrome 110.0.0.0', '2023-03-13 09:25:25', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2778, 'New Record inserted On Patient id 969', 969, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:39:01', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2779, 'Record updated On Patient id 969', 969, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:39:01', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2780, 'New Record inserted On Patient id 970', 970, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:40:20', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2781, 'Record updated On Patient id 970', 970, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:40:20', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2782, 'New Record inserted On Patient id 971', 971, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:41:28', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2783, 'Record updated On Patient id 971', 971, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:41:28', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2784, 'New Record inserted On Patient id 972', 972, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:42:49', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2785, 'Record updated On Patient id 972', 972, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:42:49', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2786, 'Record updated On Patient id 113', 113, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:44:55', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2787, 'New Record inserted On Patient id 973', 973, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:46:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2788, 'Record updated On Patient id 973', 973, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:46:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2789, 'New Record inserted On Patient id 974', 974, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:51:52', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2790, 'Record updated On Patient id 974', 974, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:51:52', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2791, 'New Record inserted On Patient id 975', 975, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:53:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2792, 'Record updated On Patient id 975', 975, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:53:41', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2793, 'New Record inserted On Patient id 976', 976, 2, 'Insert', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:56:28', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2794, 'Record updated On Patient id 976', 976, 2, 'Update', '105.112.123.106', 'Windows 10', 'Firefox 110.0', '2023-03-13 09:56:28', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2795, 'New Record inserted On Patient id 977', 977, 2, 'Insert', '105.112.114.183', 'Windows 10', 'Firefox 110.0', '2023-03-13 14:18:03', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2796, 'Record updated On Patient id 977', 977, 2, 'Update', '105.112.114.183', 'Windows 10', 'Firefox 110.0', '2023-03-13 14:18:03', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2797, 'New Record inserted On Patient id 978', 978, 2, 'Insert', '105.112.114.183', 'Windows 10', 'Firefox 110.0', '2023-03-13 14:27:04', '2023-03-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `use